/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.file;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.agent.plugins.observe.semconv.SemanticAttributes;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;

@DontObfuscate
@m
public final class FileOpenCreateDispatcherImpl
implements ContrastObserveFileOpenCreateDispatcher {
    private final e config;
    private static final String SINK_TYPE = "file-open-create";
    private static final String FILE_OPEN_PATH = "file.open.path";
    private static final Logger logger = LoggerFactory.getLogger(FileOpenCreateDispatcherImpl.class);

    public FileOpenCreateDispatcherImpl(e e2) {
        this.config = e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object string(String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = ContrastContext.current();
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return null;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return null;
        }
        scopeProvider.enterScope();
        try {
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
                Object var7_6 = null;
                return var7_6;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute(FILE_OPEN_PATH, string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uri(String string, URI uRI) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = ContrastContext.current();
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return null;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return null;
        }
        scopeProvider.enterScope();
        try {
            String string2 = uRI.getPath();
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
                Object var8_7 = null;
                return var8_7;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute(FILE_OPEN_PATH, string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    public void onFileReturnObserved(File file, String string) {
        String string2;
        if (file == null) {
            return;
        }
        try {
            string2 = file.getPath();
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
            return;
        }
        this.startAndStopFileSpan(string2, string);
    }

    public void onPathObserved(Path path, String string) {
        String string2;
        if (path == null) {
            return;
        }
        try {
            string2 = path.toString();
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
            return;
        }
        this.startAndStopFileSpan(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndStopFileSpan(String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            if (FileOpenCreateDispatcherImpl.shouldIgnore(string)) {
                return;
            }
            Span span = FileOpenCreateDispatcherImpl.onFileAccess(rootSpan, string2);
            if (span == null) {
                return;
            }
            span.setAttribute(SemanticAttributes.FILE_OPEN_PATH, string);
            span.end();
            rootSpan.popContext();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, SINK_TYPE, ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        d.a(object, SINK_TYPE);
    }

    private Span onFileAccess(String string) {
        return FileOpenCreateDispatcherImpl.onFileAccess(ContrastContext.current().observe(), string);
    }

    private static Span onFileAccess(RootSpan rootSpan, String string) {
        return rootSpan != null && rootSpan.isRecording() ? rootSpan.startChildSpan(SINK_TYPE, string) : null;
    }

    private static boolean shouldIgnore(String string) {
        return string == null || string.isEmpty() || string.endsWith(".class") || string.endsWith(".jar") || string.endsWith(".war") || string.endsWith(".ear") || string.endsWith(".css");
    }
}

