/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.serverside;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.semconv.SemanticAttributes;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

@DontObfuscate
@m
public final class ServerSideRequestDispatcherImpl
implements ContrastObserveServerSideRequestDispatcher {
    private final e config;
    private static final Set<String> EXCLUDED_PROTOCOLS = Sets.of("file", "jar", "jrt", "war", "ear");
    private static final String SINK_TYPE = "outbound-service-call";

    ServerSideRequestDispatcherImpl(e e2) {
        this.config = e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onTraceStart(String string, Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = ContrastContext.current();
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return null;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return null;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return null;
        }
        scopeProvider.enterScope();
        try {
            if (!(object instanceof URLConnection)) {
                Object var8_7 = null;
                return var8_7;
            }
            URL uRL = ((URLConnection)object).getURL();
            String string2 = uRL.getHost();
            int n2 = uRL.getPort();
            String string3 = uRL.getProtocol();
            if (string3 != null && EXCLUDED_PROTOCOLS.contains(string3.toLowerCase())) {
                Object var12_12 = null;
                return var12_12;
            }
            Span span = rootSpan.startChildSpan(SINK_TYPE, string);
            if (span == null) {
                Object var13_14 = null;
                return var13_14;
            }
            if (string2 != null) {
                span.setAttribute(SemanticAttributes.SERVER_ADDRESS, string2);
                if (n2 >= 0) {
                    span.setAttribute(SemanticAttributes.SERVER_PORT, n2);
                }
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        d.a(object, SINK_TYPE);
    }
}

