/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.spring;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.a.a;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;

@DontObfuscate
@m
public class ContrastObserveSpringDispatcherImpl
implements ContrastObserveSpringDispatcher {
    private final e config;
    private static final String ROLE_PREFIX = "ROLE_";
    private static final Logger logger = LoggerFactory.getLogger(ContrastObserveSpringDispatcherImpl.class);

    ContrastObserveSpringDispatcherImpl(e e2) {
        this.config = e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecute(Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        if (contrastContext.http().getRequest() == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            TextMapPropagator textMapPropagator = application.otel().a().getTextMapPropagator();
            textMapPropagator.inject(ContrastContext.current().observe().storeInContext(Context.root()), object2, (object, string, string2) -> Reflect.reflect(object, logger).invoke("getHeaders").invoke("add", string, string2));
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthorizationCheck(String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            httpRequest.context().putIfAbsent(RootSpan.AUTHZ_CONTEXT_KEY, a.a().a(string).b("authz-request").a(application).a());
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRouteAuthorization(Collection<String> collection, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null || contrastContext.application().current() == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            a.a a2 = a.a().a(string).b("authz-request").a(contrastContext.application().current());
            if (collection != null && !collection.isEmpty()) {
                a2.a(collection);
            }
            httpRequest.context().put(RootSpan.AUTHZ_CONTEXT_KEY, a2.a());
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHasAnyAuthorityName(String string, String[] stringArray, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            Span span = rootSpan.startChildSpan("authz-request", string2);
            if (span == null) {
                return;
            }
            if (ROLE_PREFIX.equals(string) && stringArray != null && stringArray.length > 0) {
                span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
                span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, String.join((CharSequence)", ", stringArray));
            }
            span.end();
            rootSpan.popContext();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPermissionsCheck(Object object, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            Span span = rootSpan.startChildSpan("authz-request", string);
            if (span == null) {
                return;
            }
            if (object instanceof String) {
                span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "dac");
                span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_DAC_PERMISSION, (String)object);
            }
            span.end();
            rootSpan.popContext();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
        }
        finally {
            scopeProvider.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExchangeFilter(Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = ContrastContext.current();
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ScopeProvider scopeProvider = contrastContext.scopeProvider();
        if (scopeProvider.inScope()) {
            return;
        }
        scopeProvider.enterScope();
        try {
            application.otel().a().getTextMapPropagator().inject(Context.current(), object2, (object, string, string2) -> {
                if (object != null) {
                    Reflect.reflect(object, logger).invoke("header", string, new String[]{string2});
                }
            });
        }
        finally {
            scopeProvider.leaveScope();
        }
    }
}

