/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Iterators;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsProtectDTM;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogEnhancerDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.apps.a.a.e;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.l;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.b.b;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

@DontObfuscate
@m
public class ProtectManager {
    private final CommonConfigProtectionMode globalOverrideMode;
    private final com.contrastsecurity.agent.config.e config;
    private final com.contrastsecurity.agent.plugins.protect.b.c canonicalizer;
    private final TelemetryMetrics metrics;
    private final a.a reportCardFactory;
    private final d.c<i> requestTimer;
    private com.contrastsecurity.agent.plugins.protect.c.c deadzoneManager;
    private Collection<p> rules;
    private Map<ProtectRuleId, p> ruleById;
    private List<k> inputAwareRules;
    private Map<Long, LogEnhancerDTM> logEnhancers;
    private List<com.contrastsecurity.agent.plugins.protect.a> logEnhancerList;
    private Set<String> userTargetedClasses;
    private volatile boolean activated;
    private static final Logger logger = LoggerFactory.getLogger(ProtectManager.class);

    public ProtectManager(com.contrastsecurity.agent.config.e e2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.telemetry.metrics.b.b b2, Clock clock) {
        this.config = Objects.requireNonNull(e2);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        i.a a2 = telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.PERFORMANCE_PROTECT).a("Records time taken to handle requests end-to-end, split by constituent parts (e.g. source analysis, sink analysis, etc.)").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        this.requestTimer = telemetryMetrics.newGrouped(a2).a("aspect").a(com.contrastsecurity.agent.telemetry.metrics.a.c.a());
        this.reportCardFactory = new a.a(telemetryMetrics, clock, b2);
        this.canonicalizer = new com.contrastsecurity.agent.plugins.protect.b.c(telemetryMetrics, clock);
        if (!e2.getBoolean(ConfigProperty.PROTECT_SINKS)) {
            PreConfigUtil.out("Disabling defensive instrumentation sensors. No attacks can be blocked or confirmed exploited.");
        }
        this.globalOverrideMode = ProtectManager.calcGlobalModeOverride(e2);
    }

    @o
    public ProtectManager(com.contrastsecurity.agent.config.e e2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.plugins.protect.c.c c2, b.a a2, Collection<p> collection, Clock clock) {
        this(e2, telemetryMetrics, a2, clock);
        this.initializeDeadzoneManager(c2);
        this.setRules(collection);
    }

    void initializeDeadzoneManager(com.contrastsecurity.agent.plugins.protect.c.c c2) {
        Objects.requireNonNull(c2);
        if (this.deadzoneManager != null) {
            throw new IllegalStateException("DeadzoneManager has already been initialized");
        }
        this.deadzoneManager = c2;
    }

    void setRules(Collection<p> collection) {
        Objects.requireNonNull(collection);
        if (this.rules != null) {
            throw new IllegalStateException("rules have already been set");
        }
        if (this.deadzoneManager == null) {
            throw new IllegalStateException("DeadzoneManager has not yet been initialized");
        }
        Lists.Builder<p> builder = Lists.builder();
        this.inputAwareRules = new LinkedList<k>();
        this.ruleById = new EnumMap<ProtectRuleId, p>(ProtectRuleId.class);
        for (p p2 : collection) {
            this.ruleById.put(p2.getRuleId(), p2);
            if (p2 instanceof k) {
                if (p2.g() && this.metrics.isEnabled()) {
                    p2 = new l((k)p2, this.metrics);
                }
                this.inputAwareRules.add((k)p2);
            }
            builder.add(p2);
        }
        this.rules = builder.build();
    }

    public Set<String> getUserTargetedClasses() {
        if (this.userTargetedClasses == null && this.logEnhancerList != null) {
            this.userTargetedClasses = new HashSet<String>();
            for (com.contrastsecurity.agent.plugins.protect.a a2 : this.logEnhancerList) {
                if (a2 == null) continue;
                this.userTargetedClasses.add(a2.b());
            }
        }
        return this.userTargetedClasses;
    }

    public void onServerFeatureUpdate(ServerSettingsProtectDTM serverSettingsProtectDTM) {
        if (serverSettingsProtectDTM != null) {
            List<LogEnhancerDTM> list = serverSettingsProtectDTM.getLogEnhancers();
            if (list != null) {
                this.logEnhancers = this.toLogEnhancerMap(list);
                this.logEnhancerList = this.toList(list);
                logger.info("Enabling log enhancers of size={}", (Object)this.logEnhancerList.size());
            } else {
                this.logEnhancers = Collections.emptyMap();
                this.logEnhancerList = Collections.emptyList();
                logger.info("No log enhancers provided");
            }
        }
    }

    private List<com.contrastsecurity.agent.plugins.protect.a> toList(List<LogEnhancerDTM> list) {
        ArrayList<com.contrastsecurity.agent.plugins.protect.a> arrayList = new ArrayList<com.contrastsecurity.agent.plugins.protect.a>();
        if (list != null) {
            for (LogEnhancerDTM logEnhancerDTM : list) {
                arrayList.add(new com.contrastsecurity.agent.plugins.protect.a(logEnhancerDTM));
            }
        }
        return arrayList;
    }

    private Map<Long, LogEnhancerDTM> toLogEnhancerMap(List<LogEnhancerDTM> list) {
        HashMap<Long, LogEnhancerDTM> hashMap = new HashMap<Long, LogEnhancerDTM>();
        for (LogEnhancerDTM logEnhancerDTM : list) {
            hashMap.put(logEnhancerDTM.getId(), logEnhancerDTM);
        }
        return hashMap;
    }

    Collection<p> getRules() {
        return this.rules;
    }

    public Iterable<p> getEnabledRules(HttpRequest httpRequest, ProtectContext protectContext, Application application) {
        return this.filterEnabled(this.rules, httpRequest, protectContext, application);
    }

    public List<k> getEnabledInputRulesCalculated(HttpRequest httpRequest, ProtectContext protectContext, Application application) {
        ArrayList<k> arrayList = new ArrayList<k>();
        for (k k2 : this.getEnabledInputAwareRules(httpRequest, protectContext, application)) {
            arrayList.add(k2);
        }
        return arrayList;
    }

    public Iterable<k> getEnabledInputAwareRules(HttpRequest httpRequest, ProtectContext protectContext, Application application) {
        return this.filterEnabled(this.inputAwareRules, httpRequest, protectContext, application);
    }

    public Iterable<k> getInputAwareRules(ProtectContext protectContext, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string) {
        return this.getInputAwareRules(new b<k>(protectContext, inputType, exceptionInputTypeDTM, string, this, ContrastContext.current().application().current()));
    }

    public Iterable<k> getInputAwareRules(Predicate<k> predicate) {
        ContrastContext contrastContext = ContrastContext.current();
        a<k> a2 = new a<k>(predicate, this, contrastContext.http().getRequest(), contrastContext.protect(), contrastContext.application().current());
        return () -> Iterators.filterIterator(this.inputAwareRules, a2);
    }

    public <T extends p> Iterable<T> filterEnabled(Collection<T> collection, ProtectContext protectContext) {
        return () -> {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            ContrastContext contrastContext = ContrastContext.current();
            Application application = contrastContext.application().current();
            return Iterators.filterIterator(collection, new c(this, contrastContext.http().getRequest(), protectContext, application));
        };
    }

    public <T extends p> Iterable<T> filterEnabled(Collection<T> collection, HttpRequest httpRequest, ProtectContext protectContext, Application application) {
        return () -> {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Iterators.filterIterator(collection, new c(this, httpRequest, protectContext, application));
        };
    }

    private <T extends p> Iterator<T> filterEnabledIterator(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyIterator();
        }
        ContrastContext contrastContext = ContrastContext.current();
        Application application = contrastContext.application().current();
        return Iterators.filterIterator(collection, new c(this, contrastContext.http().getRequest(), contrastContext.protect(), contrastContext.application().current()));
    }

    public boolean isDisabledByInputExclusion(p p2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, Application application) {
        Objects.requireNonNull(p2);
        Objects.requireNonNull(exceptionInputTypeDTM);
        g g2 = this.getApplicationExclusionProcessor(application);
        if (g2 == null) {
            return false;
        }
        return g2.isInputExclusion(c.a.b, p2.getRuleId().id(), string, exceptionInputTypeDTM);
    }

    public g getApplicationExclusionProcessor(Application application) {
        if (application == null) {
            return null;
        }
        return application.getExclusionProcessor();
    }

    public p getRuleById(ProtectRuleId protectRuleId) {
        return this.ruleById.get((Object)protectRuleId);
    }

    @o
    public <T extends p> T getRuleById(ProtectRuleId protectRuleId, Class<T> clazz) {
        return (T)((p)clazz.cast(this.ruleById.get((Object)protectRuleId)));
    }

    public boolean isSinksDisabled() {
        return !this.config.getBoolean(ConfigProperty.PROTECT_SINKS);
    }

    public boolean shouldProcessSink() {
        return this.activated && this.config.getBoolean(ConfigProperty.PROTECT_SINKS);
    }

    public ProtectContext newContext() {
        return ContrastContext.current().protect(new ProtectContext(this.canonicalizer, this.reportCardFactory.a(this.requestTimer)));
    }

    public LogEnhancerDTM getLogEnhancerById(long l2) {
        return this.logEnhancers.get(l2);
    }

    public List<com.contrastsecurity.agent.plugins.protect.a> getLogEnhancers() {
        return this.logEnhancerList;
    }

    private CommonConfigProtectionMode getAppRuleMode(p p2) {
        if (this.globalOverrideMode != null) {
            return this.globalOverrideMode;
        }
        return p2.getProtectRuleMode().a();
    }

    @o
    CommonConfigProtectionMode getGlobalModeOverride() {
        return this.globalOverrideMode;
    }

    static CommonConfigProtectionMode calcGlobalModeOverride(com.contrastsecurity.agent.config.e e2) {
        ProtectionModeDTM protectionModeDTM = e2.getEnumOrNull(ProtectionModeDTM.class, ConfigProperty.PROTECT_RULE_MODE_OVERRIDE);
        return protectionModeDTM == null ? null : protectionModeDTM.toCommonConfig();
    }

    public boolean isRuleDisabled(ProtectRuleId protectRuleId) {
        p p2 = this.ruleById.get((Object)protectRuleId);
        if (p2 == null) {
            return true;
        }
        ContrastContext contrastContext = ContrastContext.current();
        return this.isRuleDisabled(p2, contrastContext.http().getRequest(), contrastContext.protect(), contrastContext.application().current());
    }

    @o
    public boolean isRuleDisabled(p p2) {
        ContrastContext contrastContext = ContrastContext.current();
        return this.isRuleDisabled(p2, contrastContext.http().getRequest(), contrastContext.protect(), contrastContext.application().current());
    }

    public boolean isRuleDisabled(p p2, HttpRequest httpRequest, ProtectContext protectContext, Application application) {
        Object object;
        Application application2;
        ProtectContext protectContext2;
        if (p2.a()) {
            return false;
        }
        if (!this.ruleById.containsKey((Object)p2.getRuleId().baseRuleId())) {
            return true;
        }
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(p2);
        if (CommonConfigProtectionMode.OFF == commonConfigProtectionMode) {
            return true;
        }
        if (!this.shouldProcessSink()) {
            return true;
        }
        ContrastContext contrastContext = ContrastContext.current();
        ProtectContext protectContext3 = protectContext2 = protectContext == null ? contrastContext.protect() : protectContext;
        if (protectContext2 != null && protectContext2.isRuleDisabled(p2.getRuleId())) {
            return true;
        }
        String string = p2.getRuleId().baseRuleId().id();
        if (this.deadzoneManager.b(string)) {
            return true;
        }
        Application application3 = application2 = application == null ? contrastContext.application().current() : application;
        if (application2 == null) {
            return false;
        }
        g g2 = application2.getExclusionProcessor();
        if (g2.hasUrlExclusions(c.a.b)) {
            Object object2 = object = httpRequest == null ? contrastContext.http().getRequest() : httpRequest;
            if (object != null && com.contrastsecurity.agent.apps.exclusions.o.a(((HttpRequest)object).context(), ((HttpRequest)object).getUri(), g2, c.a.b, string)) {
                return true;
            }
        }
        if ((object = application2.context().get(e.a)) == null) {
            return false;
        }
        return ((e)object).a(string, c.a.b);
    }

    public boolean canBlock(p p2) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(p2);
        return CommonConfigProtectionMode.BLOCK.equals((Object)commonConfigProtectionMode) || CommonConfigProtectionMode.BLOCK_AT_PERIMETER.equals((Object)commonConfigProtectionMode);
    }

    boolean shouldBlockAtPerimeter(k k2, UserInputDTM.InputType inputType) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(k2);
        return commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK_AT_PERIMETER || commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK && k2.a(inputType);
    }

    public boolean isScanParameterAsAnything() {
        return this.config.getBoolean(ConfigProperty.INSPECT_PARAMETERS_AS_JSON) || this.config.getBoolean(ConfigProperty.INSPECT_PARAMETERS_AS_XML);
    }

    public void checkParameterAccess() {
        ProtectContext protectContext = ContrastContext.current().protect();
        if (protectContext.shouldThrowExceptionOnParameterAccess()) {
            throw new AttackBlockedException("Attack already detected in parameters");
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    static final class c<T extends p>
    implements Predicate<T> {
        private final ProtectManager a;
        private final HttpRequest b;
        private final ProtectContext c;
        private final Application d;

        c(ProtectManager protectManager, HttpRequest httpRequest, ProtectContext protectContext, Application application) {
            this.a = protectManager;
            this.b = httpRequest;
            this.c = protectContext;
            this.d = application;
        }

        public boolean a(T t2) {
            return !this.a.isRuleDisabled((p)t2, this.b, this.c, this.d);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class a<T extends p>
    implements Predicate<T> {
        private final Predicate<T> a;
        private final Predicate<T> b;

        a(Predicate<T> predicate, ProtectManager protectManager, HttpRequest httpRequest, ProtectContext protectContext, Application application) {
            this.a = predicate;
            this.b = new c(protectManager, httpRequest, protectContext, application);
        }

        public boolean a(T t2) {
            return this.a.test(t2) && this.b.test(t2);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class b<T extends k>
    implements Predicate<T> {
        private final ProtectContext a;
        private final UserInputDTM.InputType b;
        private final ExceptionInputTypeDTM c;
        private final String d;
        private final ProtectManager e;
        private final Application f;

        b(ProtectContext protectContext, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, ProtectManager protectManager, Application application) {
            this.a = protectContext;
            this.b = inputType;
            this.c = exceptionInputTypeDTM;
            this.d = string;
            this.e = protectManager;
            this.f = application;
        }

        public boolean a(T t2) {
            boolean bl2;
            ProtectRuleId protectRuleId = t2.getRuleId();
            boolean bl3 = bl2 = t2.appliesToInputType(this.b) && !this.a.isRuleDisabled(protectRuleId) && !this.e.isDisabledByInputExclusion((p)t2, this.c, this.d, this.f);
            if (!bl2 && logger.isTraceEnabled()) {
                logger.trace("Skipping {} input scanning for {} for {} due to exception", this.b.logName(), protectRuleId.id(), this.d);
            }
            return bl2;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((k)object);
        }
    }
}

