/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.a.a;
import com.contrastsecurity.agent.telemetry.metrics.b.b;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import java.time.Duration;
import java.util.Objects;

@DontObfuscate
@m
public class AssessmentManager {
    private final Clock clock;
    private final e config;
    private final HeapProfiler heapProfiler;
    private final a.a reportCardFactory;
    private final d.c<i> requestTimer;
    private final Counter snapshotCacheHit;
    private final Counter snapshotCacheMiss;
    private int contextsCreated;
    private long totalMapSize;
    private volatile boolean enableCaptureRecentFindings;
    private static final int DEFAULT_TRACEMAP_SIZE = 75;
    private static final int MINIMUM_CONTEXTS_BEFORE_PREDICTING_TRACEMAP_SIZE = 5;

    public AssessmentManager(Clock clock, e e2, TelemetryMetrics telemetryMetrics, b b2, HeapProfiler heapProfiler) {
        this.clock = clock;
        this.config = e2;
        this.heapProfiler = heapProfiler;
        Objects.requireNonNull(telemetryMetrics);
        i.a a2 = telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.ASSESS).a("Records total time taken to handle requests").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        this.requestTimer = telemetryMetrics.newGrouped(a2).a("aspect").a(a.a());
        this.reportCardFactory = new a.a(telemetryMetrics, clock, b2);
        this.snapshotCacheHit = telemetryMetrics.newCounter("snapshotCacheHitCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache hits in Assess").register();
        this.snapshotCacheMiss = telemetryMetrics.newCounter("snapshotCacheMissCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache misses in Assess").register();
    }

    public AssessmentContext newContext() {
        return this.newContext(ContrastContext.current());
    }

    public AssessmentContext newContext(ContrastContext contrastContext) {
        AssessmentContext assessmentContext = contrastContext.assessment();
        if (assessmentContext != null && !assessmentContext.isJumpedContexts()) {
            assessmentContext.clear();
        }
        int n2 = this.contextsCreated > 5 ? Math.max((int)Math.min(this.totalMapSize / (long)this.contextsCreated, 250L), 20) : 75;
        AssessmentContext assessmentContext2 = this.heapProfiler.saveForProfiling(new AssessmentContext(this.config, this.clock, n2, this.snapshotCacheHit, this.snapshotCacheMiss, this.reportCardFactory.a(this.requestTimer)));
        contrastContext.assessment(assessmentContext2);
        if (this.enableCaptureRecentFindings) {
            assessmentContext2.enableCaptureRecentFindings();
        }
        return assessmentContext2;
    }

    public void onContextClearing(int n2) {
        ++this.contextsCreated;
        this.totalMapSize += (long)n2;
    }

    @o
    public void enableCaptureRecentFindings() {
        this.enableCaptureRecentFindings = true;
    }
}

