/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.security.AssessContextSnapshotCache;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

@DontObfuscate
@m
public class EventContext
implements Purgeable {
    private boolean enabled;
    private final TraceMapStrategy traceMapStrategy;
    private final Clock clock;
    private final Map<Object, Trace> globalTraceMap;
    private final long maxStronglyReachableTraceTtl;
    private static final Logger logger = LoggerFactory.getLogger(EventContext.class);

    public EventContext(e e2, Clock clock, HeapProfiler heapProfiler) {
        this.clock = clock;
        this.maxStronglyReachableTraceTtl = e2.getLong(ConfigProperty.MAX_TRACE_TTL);
        this.traceMapStrategy = EventContext.traceMapStrategyFromConfig(e2);
        @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.SHALLOW, ownedCaches={AssessContextSnapshotCache.class, AssessmentContext.a.class})
        final class A
        extends b {
            A(int n2) {
                super(n2);
            }
        }
        this.globalTraceMap = heapProfiler.saveForProfiling(new A(10000));
    }

    static TraceMapStrategy traceMapStrategyFromConfig(e e2) {
        String string = e2.get(ConfigProperty.TRACE_MAP_STRATEGY);
        TraceMapStrategy traceMapStrategy = TraceMapStrategy.valueOfIgnoreCase(string);
        if (traceMapStrategy == null) {
            throw new com.contrastsecurity.agent.config.c.b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.TRACE_MAP_STRATEGY) + ". Valid values are GLOBAL, CONTEXT, BOTH.");
        }
        return traceMapStrategy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public Map<Object, Trace> getTraceMap() {
        ContrastContext contrastContext = ContrastContext.current();
        return this.getTraceMap(this.traceMapStrategy == TraceMapStrategy.GLOBAL ? null : contrastContext.assessment());
    }

    public Map<Object, Trace> getTraceMap(AssessmentContext assessmentContext) {
        switch (this.traceMapStrategy) {
            case GLOBAL: {
                return this.globalTraceMap;
            }
            case CONTEXT: {
                return assessmentContext == null ? null : assessmentContext.getTraceMap();
            }
            case BOTH: {
                Map<Object, Trace> map = assessmentContext == null ? null : assessmentContext.getTraceMap();
                return map == null ? this.globalTraceMap : map;
            }
        }
        throw new IllegalStateException("Unknown Trace Map Strategy: " + (Object)((Object)this.traceMapStrategy));
    }

    public <T extends Trace> Map<Object, Trace> putTrace(AssessmentContext assessmentContext, Object object, T t2) {
        Map<Object, Trace> map = this.getTraceMap(assessmentContext);
        map.put(object, t2);
        return map;
    }

    @Override
    public void purgeStale() {
        ContrastContext contrastContext = ContrastContext.current();
        AssessmentContext assessmentContext = contrastContext.assessment();
        Map<Object, Trace> map = this.getTraceMap(assessmentContext);
        if (map != null) {
            this.removeDeadTraces(map);
            this.removeExpiredTraces(map);
        }
        if (assessmentContext == null) {
            return;
        }
        assessmentContext.clearLastMethodEvent();
    }

    private void removeDeadTraces(Map<Object, Trace> map) {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = (ConcurrentReferenceHashMap)map;
        concurrentReferenceHashMap.dumpStats();
        concurrentReferenceHashMap.purgeStaleEntries();
    }

    private void removeExpiredTraces(Map<Object, Trace> map) {
        Iterator<Map.Entry<Object, Trace>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Trace> entry;
            Trace trace = null;
            try {
                entry = iterator.next();
                trace = (Trace)entry.getValue();
                if (!this.shouldRemoveTrace(trace)) continue;
                Object k2 = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing expired key=[{}] with identity=[{}] and value=[{}] from trace map=[{}].", k2, JVMUtils.getSafeToString(k2, true), JVMUtils.getSafeToString(trace, true), JVMUtils.getSafeToString(map, true));
                }
                iterator.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                entry = throwable;
                logger.error("Problem pruning old trace {}", trace != null ? Long.valueOf(trace.getId()) : "null", (Object)entry);
            }
        }
    }

    private boolean shouldRemoveTrace(Trace trace) {
        CodeEvent codeEvent = trace.getFirstEvent();
        if (codeEvent == null) {
            return true;
        }
        long l2 = codeEvent.getTimestamp();
        long l3 = this.clock.now() - l2;
        return l3 > this.maxStronglyReachableTraceTtl;
    }

    @Override
    public int purgeableCount() {
        Map<Object, Trace> map = this.getTraceMap();
        return map != null ? map.size() : 0;
    }

    public Integer getTrackedItemHash(AssessmentContext assessmentContext, Object[] objectArray) {
        Map<Object, Trace> map = this.getTraceMap(assessmentContext);
        if (map == null) {
            return null;
        }
        Trace trace = map.get(objectArray);
        if (trace != null) {
            return Arrays.hashCode(objectArray);
        }
        for (Object object : objectArray) {
            Integer n2;
            if (object == null) continue;
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz != null && !clazz.isPrimitive() && (n2 = this.getTrackedItemHash(assessmentContext, (Object[])object)) != null) {
                return n2;
            }
            trace = map.get(object);
            if (trace == null) continue;
            return object.hashCode();
        }
        return null;
    }

    @HeapUsage.SupportsHeapProfiling
    public static class b
    extends ConcurrentReferenceHashMap<Object, Trace> {
        private b(int n2) {
            super(n2, 0.75f, 32, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.range(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS, ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        }

        public static Map<Object, Trace> a(int n2) {
            return new b(n2);
        }
    }
}

