/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.propagate;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.propagate.c;
import com.contrastsecurity.agent.plugins.security.model.g;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.AdaptiveOptimizationManager;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.d;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.e;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Map;

@DontObfuscate
@m
public final class PropagationHandler
implements com.contrastsecurity.agent.plugins.security.policy.m {
    private ContrastPolicy.c propagators;
    private Map<Integer, Propagator> customSanitizers;
    private final c propagationMachine;
    private final ScopeProviderAssess scopeProviderAssess;
    private final EventContext eventContext;
    private final TraceController traceController;
    private final i stackCaptureFactory;
    private final a methodDescriptionCache;
    private final d propagatorAdaptiveOptimizer;
    private final ContrastPolicyManager policyManager;
    private final Collection<com.contrastsecurity.agent.plugins.security.d.a> propagationListeners;
    private static final Logger logger = LoggerFactory.getLogger(PropagationHandler.class);

    public PropagationHandler(c c2, ScopeProviderAssess scopeProviderAssess, EventContext eventContext, TraceController traceController, i i2, a a2, ContrastPolicyManager contrastPolicyManager, AdaptiveOptimizationManager adaptiveOptimizationManager, Instrumentation instrumentation, o o2, Collection<com.contrastsecurity.agent.plugins.security.d.a> collection) {
        this.propagationMachine = c2;
        this.scopeProviderAssess = scopeProviderAssess;
        this.eventContext = eventContext;
        this.traceController = traceController;
        this.stackCaptureFactory = i2;
        this.methodDescriptionCache = a2;
        this.propagatorAdaptiveOptimizer = new e(adaptiveOptimizationManager, instrumentation, o2);
        this.policyManager = contrastPolicyManager;
        this.propagationListeners = collection;
        ContrastPolicy contrastPolicy = contrastPolicyManager.currentPolicy();
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    @Override
    public void onPolicyChanged(ContrastPolicy contrastPolicy) {
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    public boolean isScopedPropagationAllowed(ScopeAssess scopeAssess) {
        if (!this.scopeProviderAssess.isEnabled()) {
            return false;
        }
        return scopeAssess.getSamplingScope() == 0 && scopeAssess.scope() == 0 && scopeAssess.getPropagationScope() == 1;
    }

    public boolean isUnscopedPropagationAllowed(ScopeAssess scopeAssess) {
        if (!this.scopeProviderAssess.isEnabled()) {
            return true;
        }
        return scopeAssess.getSamplingScope() == 0 && scopeAssess.scope() == 0;
    }

    public void enterPropagationScope(ScopeAssess scopeAssess) {
        scopeAssess.enterPropagationScope();
    }

    public void leavePropagationScope(ScopeAssess scopeAssess) {
        scopeAssess.leavePropagationScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropagation(ScopeAssess scopeAssess, String string, String string2, int n2, Object object, Class<?> clazz, Object[] objectArray, Object object2, Class<?> clazz2, int n3, boolean bl2, boolean bl3) {
        try {
            scopeAssess.enterScope();
            Propagator propagator = this.getPropagator(n3, bl2);
            ContrastContext contrastContext = ContrastContext.current();
            AssessmentContext assessmentContext = contrastContext.assessment();
            if (assessmentContext != null && assessmentContext.hasReachedMaximumPropagationEvents()) {
                if (propagator.loggedMaximumEvents()) {
                    logger.debug("Ignoring propagator {} because maximum reached", (Object)propagator.getId());
                } else {
                    logger.warn("Ignoring propagator {} because maximum reached, consider increasing maximum events via the `assess.max_propagation_events` property. Further events will be logged at the `DEBUG` level", (Object)propagator.getId());
                }
                return;
            }
            Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
            if (map == null) {
                return;
            }
            if (!this.shouldPropagate(assessmentContext, propagator, clazz, object, objectArray, clazz2, object2)) {
                return;
            }
            MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, clazz.getName(), string, string2, n2);
            g g2 = new g(assessmentContext);
            g2.a(object);
            g2.a(objectArray);
            g2.b(object2);
            g2.a(methodDescription);
            g2.a(propagator);
            g2.a(clazz);
            g2.b(clazz2);
            g2.a(bl3);
            g2.a(map);
            g2.b(System.currentTimeMillis());
            g2.a(this.stackCaptureFactory.a(i.a.b));
            for (com.contrastsecurity.agent.plugins.security.d.a a2 : this.propagationListeners) {
                if (a2.a(g2)) continue;
                return;
            }
            this.doPropagation(assessmentContext, g2);
            this.propagatorAdaptiveOptimizer.a(this.policyManager, g2);
            if (assessmentContext != null) {
                assessmentContext.onPropagationRecorded();
            }
            for (com.contrastsecurity.agent.plugins.security.d.a a2 : this.propagationListeners) {
                a2.a(scopeAssess, g2);
            }
        }
        catch (InvalidTagRangeException invalidTagRangeException) {
            logger.debug("Invalid tag range exception", invalidTagRangeException);
        }
        finally {
            scopeAssess.leaveScope();
        }
    }

    private Propagator getPropagator(int n2, boolean bl2) {
        Propagator propagator;
        if (bl2 && logger.isDebugEnabled()) {
            logger.debug("custom sanitizer propagator index detected {} ({} total standard propagators)", (Object)n2, (Object)this.propagators.b());
        }
        Propagator propagator2 = propagator = bl2 ? this.customSanitizers.get(n2) : this.propagators.a(n2);
        if (propagator == null) {
            throw new IllegalStateException("Unable to find valid propagator at index " + n2);
        }
        return propagator;
    }

    private boolean shouldPropagate(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Object[] objectArray, Class<?> clazz2, Object object2) {
        return this.verifySourcePropagation(assessmentContext, propagator, clazz, object, objectArray) && this.verifyTargetPropagation(assessmentContext, propagator, clazz, object, clazz2, object2);
    }

    private boolean verifySourcePropagation(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Object[] objectArray) {
        Location[] locationArray = propagator.getSources();
        Location[] locationArray2 = propagator.getTargets();
        boolean bl2 = false;
        if (locationArray != null && locationArray2 != null) {
            if (locationArray.length == 1 && locationArray2.length == 1) {
                Location location = locationArray[0];
                Location location2 = locationArray2[0];
                bl2 = location.isObject() && location2.isObject() ? clazz != String.class && this.traceController.isTracked(assessmentContext, object) : true;
            } else {
                for (int i2 = 0; i2 < locationArray.length && !bl2; ++i2) {
                    Location location = locationArray[i2];
                    if (location.isObject()) {
                        bl2 = this.traceController.isTracked(assessmentContext, object);
                        continue;
                    }
                    if (objectArray == null) continue;
                    if (location.isNumberedParameter()) {
                        int n2 = location.getActualParameterIndex();
                        if (n2 >= objectArray.length) continue;
                        bl2 = this.traceController.isTracked(assessmentContext, objectArray[n2]);
                        continue;
                    }
                    if (!location.isParameter()) continue;
                    String string = location.getDescriptor();
                    for (int i3 = 0; !bl2 && i3 < objectArray.length; ++i3) {
                        if (objectArray[i3] == null || !JVMUtils.isInstanceOf(objectArray[i3], string)) continue;
                        bl2 = this.traceController.isTracked(assessmentContext, objectArray[i3]);
                    }
                }
            }
        }
        return bl2;
    }

    private boolean verifyTargetPropagation(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Class<?> clazz2, Object object2) {
        Location[] locationArray = propagator.getTargets();
        boolean bl2 = false;
        Object object3 = null;
        Class<?> clazz3 = null;
        if (locationArray != null) {
            for (int i2 = 0; i2 < locationArray.length && !bl2; ++i2) {
                Location location = locationArray[i2];
                if (location.isObject()) {
                    object3 = object;
                    clazz3 = clazz;
                } else if (location.isReturn()) {
                    object3 = object2;
                    clazz3 = clazz2;
                } else {
                    bl2 = true;
                }
                if (bl2) continue;
                bl2 = object3 != null;
                bl2 = bl2 && (clazz3 != String.class || !this.traceController.isTracked(assessmentContext, object3));
            }
        }
        return bl2;
    }

    private void doPropagation(AssessmentContext assessmentContext, g g2) throws InvalidTagRangeException {
        Propagator propagator = g2.f();
        boolean bl2 = g2.j();
        Map<Object, Trace> map = g2.l();
        Location[] locationArray = propagator.getSources();
        Location[] locationArray2 = propagator.getTargets();
        if (locationArray != null && locationArray2 != null) {
            boolean bl3;
            Location location;
            int n2;
            int n3 = -1;
            for (n2 = 0; n2 < locationArray.length; ++n2) {
                location = locationArray[n2];
                if (location.isObject() && this.traceController.isTracked(assessmentContext, g2.c())) {
                    n3 = n2;
                    continue;
                }
                if (!location.isParameter() || (bl3 = location.getActualParameterIndex()) || !this.traceController.isTracked(assessmentContext, g2.d()[bl3])) continue;
                n3 = n2;
            }
            for (n2 = 0; n2 < locationArray.length; ++n2) {
                location = locationArray[n2];
                bl3 = n2 == locationArray.length - 1;
                bl3 = bl3 || n2 == n3;
                bl3 = bl3 || location.isParameter() && propagator.getCountOfArgSources() > 1;
                Object object = this.getObjectFromContextAtLocation(g2, location);
                for (Location location2 : locationArray2) {
                    Object object2 = this.getObjectFromContextAtLocation(g2, location2);
                    if (object == null || object2 == null) continue;
                    if (location.isObject() && location2.isObject()) {
                        this.propagationMachine.a(assessmentContext, object, g2);
                        continue;
                    }
                    this.propagationMachine.a(object, object2, g2, bl2, map, bl3);
                }
            }
        }
    }

    private Object getObjectFromContextAtLocation(g g2, Location location) {
        Object object = g2.c();
        Object object2 = g2.e();
        Object[] objectArray = g2.d();
        Object object3 = null;
        if (location.isObject()) {
            object3 = object;
        } else if (location.isNumberedParameter()) {
            int n2 = location.getActualParameterIndex();
            object3 = n2 < objectArray.length ? objectArray[n2] : null;
        } else if (location.isTypedParameter()) {
            for (int i2 = 0; object3 == null && i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || !JVMUtils.isInstanceOf(objectArray[i2], location.getParameterType())) continue;
                object3 = objectArray[i2];
            }
        } else if (location.isReturn()) {
            object3 = object2;
        }
        return object3;
    }
}

