/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.trigger;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.f.c;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.i;
import com.contrastsecurity.agent.plugins.security.controller.trigger.m;
import com.contrastsecurity.agent.plugins.security.e;
import com.contrastsecurity.agent.plugins.security.j;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public final class QueueFindingListener
implements m {
    private final Finding.d findingFactory;
    private final f legacyReportingService;
    private final j.c cryptographicHasher;
    private final j.d dataflowHasher;
    private final e disabledRulesFilter;
    private static final String INVALID_DATA_FLOW_ERROR = "dataflow.invalid.notenough";
    private static final Logger logger = LoggerFactory.getLogger(QueueFindingListener.class);

    public QueueFindingListener(Finding.d d2, f f2, j j2, e e2) {
        this.findingFactory = d2;
        this.legacyReportingService = f2;
        this.cryptographicHasher = j2.c();
        this.dataflowHasher = j2.e();
        this.disabledRulesFilter = e2;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, i i2) {
        ContrastContext contrastContext = ContrastContext.current();
        String string = rule.getId();
        if (this.shouldUpdateIdToStoredXSS(string, trace)) {
            string = "stored-xss";
        }
        if (this.disabledRulesFilter.a(application).test(string)) {
            logger.debug("Suppressed trace {} in {} for the disabled rule {}", trace.getId(), application, string);
            return false;
        }
        if (this.isInvalidDataFlow(rule, trace)) {
            a.a(INVALID_DATA_FLOW_ERROR, logger, "Not enough data flow events for trace {}", null, new Object[]{c.a(logger, String.valueOf(trace))});
            logger.debug("Suppressed trace {} w/o enough events {}", (Object)trace.getId(), (Object)trace);
            return false;
        }
        long l2 = "crypto-bad-ciphers".equals(string) || "crypto-bad-mac".equals(string) ? this.cryptographicHasher.a(rule.getId(), contrastContext.http().getRequest(), objectArray.length == 0 ? QueueFindingListener.getCryptoHashArgument(trace) : (String)objectArray[0]) : this.dataflowHasher.a(rule.getId(), contrastContext.http().getRequest(), trace);
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        finding.setRequest(contrastContext.http().getRequest());
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)finding.getHash());
        this.legacyReportingService.a(finding);
        AssessmentContext assessmentContext = contrastContext.assessment();
        if (assessmentContext != null && finding.hasEvents()) {
            assessmentContext.onFindingOccurred(string, finding);
        }
        return true;
    }

    private static String getCryptoHashArgument(Trace trace) {
        if (trace == null) {
            return "";
        }
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent == null) {
            return "";
        }
        MethodDescription methodDescription = codeEvent.getMethod();
        if (methodDescription == null) {
            return "";
        }
        String string = methodDescription.getSignature();
        return string == null ? "" : string;
    }

    private boolean isInvalidDataFlow(Rule rule, Trace trace) {
        if (rule.requiresDataFlow() && trace != null) {
            List<CodeEvent> list = trace.getEvents();
            return list != null && list.size() <= 1;
        }
        return false;
    }

    private boolean shouldUpdateIdToStoredXSS(String string, Trace trace) {
        List<CodeEvent> list;
        if ("reflected-xss".equals(string) && trace != null && (list = trace.getEvents()) != null && !list.isEmpty()) {
            for (CodeEvent codeEvent : list) {
                SourceNode sourceNode;
                if (!(codeEvent instanceof SourceEvent) || (sourceNode = ((SourceEvent)codeEvent).getSource()) == null || !sourceNode.hasSourceTypes() || !sourceNode.isSourceType(u.i) && !sourceNode.isSourceType(u.b)) continue;
                return true;
            }
        }
        return false;
    }
}

