/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.features.b;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.p.c;
import com.contrastsecurity.agent.plugins.h;
import com.contrastsecurity.agent.plugins.security.i;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.g;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.plugins.security.policy.propagators.a;
import com.contrastsecurity.agent.s.D;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.time.StopWatch;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@m
@DontObfuscate
public class ContrastPolicyManager {
    final i policyFinder;
    final a customSecurityControlTranslator;
    final d policyReader;
    final e config;
    final D serverInfo;
    private final b featureManager;
    private final List<com.contrastsecurity.agent.plugins.security.policy.m> policyChangedListeners;
    public volatile ContrastPolicy policy;
    private static final String RESET_DATAFLOW_SENSOR_USAGE_METRICS = "resetDataFlowSensorUsage";
    private static final Logger logger = LoggerFactory.getLogger(ContrastPolicyManager.class);

    public ContrastPolicyManager(e e2, D d2, i i2, a a2, d d3, b b2) {
        this.policyFinder = i2;
        this.customSecurityControlTranslator = a2;
        this.policyReader = d3;
        this.config = e2;
        this.serverInfo = d2;
        this.featureManager = b2;
        this.policyChangedListeners = new CopyOnWriteArrayList<com.contrastsecurity.agent.plugins.security.policy.m>();
    }

    public i getPolicyFinder() {
        return this.policyFinder;
    }

    public d getPolicyReader() {
        return this.policyReader;
    }

    public a getLevel1RuleTranslator() {
        return this.customSecurityControlTranslator;
    }

    @o
    public void initialize() throws h {
        ContrastPolicy contrastPolicy;
        try {
            String string;
            List<com.contrastsecurity.agent.p.d> list = this.policyFinder.a(false);
            String string2 = this.config.getOrNull(ConfigProperty.POLICY);
            if (!StringUtils.isEmpty(string2)) {
                list.addAll(this.parseLocationsOutOfContrastProperty(string2));
            }
            if (!StringUtils.isEmpty(string = this.config.getOrNull(ConfigProperty.POLICY_OVERRIDES))) {
                list.addAll(this.parseLocationsOutOfContrastProperty(string));
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            contrastPolicy = this.policyReader.a(this.featureManager.b(), list);
            if (contrastPolicy == null) {
                logger.error("Couldn't find any suitable policies, only reporting to local listeners (e.g., Eclipse Plugin).");
                PreConfigUtil.out("[!] Couldn't find any suitable policies, only reporting to local listeners (e.g., Eclipse Plugin).");
                return;
            }
            stopWatch.stop();
            PerfUtil.printStartupTimingMessage(String.format("Took %s to deserialize %s policies into objects", stopWatch, list.size()));
        }
        catch (n n2) {
            throw new h(n2);
        }
        this.setPolicy(contrastPolicy);
    }

    @o
    public void setPolicy(ContrastPolicy contrastPolicy) {
        if (contrastPolicy == this.policy) {
            return;
        }
        this.policy = contrastPolicy;
        for (com.contrastsecurity.agent.plugins.security.policy.m m2 : this.policyChangedListeners) {
            m2.onPolicyChanged(contrastPolicy);
        }
    }

    public <T extends com.contrastsecurity.agent.plugins.security.policy.m> T addPolicyChangedListener(T t2) {
        this.policyChangedListeners.add(t2);
        return t2;
    }

    public ContrastPolicy currentPolicy() {
        return this.policy;
    }

    private List<com.contrastsecurity.agent.p.d> parseLocationsOutOfContrastProperty(String string) throws n {
        String[] stringArray;
        ArrayList<com.contrastsecurity.agent.p.d> arrayList = new ArrayList<com.contrastsecurity.agent.p.d>();
        for (String string2 : stringArray = string.split("[\\s]*;[\\s]*")) {
            arrayList.add(c.a(string2, this.config, this.serverInfo));
        }
        return arrayList;
    }

    public void addPropagator(Propagator propagator) {
        ContrastPolicy contrastPolicy = this.policy.withNewPropagator(propagator);
        this.setPolicy(contrastPolicy);
    }

    public void addSource(SourceNode sourceNode) {
        ContrastPolicy contrastPolicy = this.policy.withNewSourceNode(sourceNode);
        this.setPolicy(contrastPolicy);
    }

    public void addDynamicSource(SourceNode sourceNode) {
        ContrastPolicy contrastPolicy = this.policy.withNewSourceNode(sourceNode);
        this.setPolicy(contrastPolicy);
    }

    public void addFeatureChanges(com.contrastsecurity.agent.plugins.security.policy.rules.a a2, List<com.contrastsecurity.agent.plugins.security.policy.rules.a.c> list) {
        ContrastPolicy.a a3 = new ContrastPolicy.a(this.policy, this.customSecurityControlTranslator);
        a2.a(a3, list);
        ContrastPolicy contrastPolicy = this.policy.withNewCustomRulesCollection(a3);
        this.setPolicy(contrastPolicy);
    }

    public void addDeadzones(Collection<g> collection) {
        ContrastPolicy contrastPolicy = this.policy.withNewDeadzones(collection);
        this.setPolicy(contrastPolicy);
    }

    public void resetUsageMetrics() {
        for (Propagator propagator : this.currentPolicy().getFastPropagatorLookup().a()) {
            propagator.resetUsageMetrics();
        }
        for (SourceNode sourceNode : this.currentPolicy().getSources()) {
            sourceNode.resetUsageMetrics();
        }
    }
}

