/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.p.e;
import com.contrastsecurity.agent.plugins.security.policy.PolicyNode;
import com.contrastsecurity.agent.plugins.security.policy.k;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.EventPattern;
import com.contrastsecurity.agent.plugins.security.policy.rules.Parameter;
import com.contrastsecurity.agent.plugins.security.policy.rules.ParameterList;
import com.contrastsecurity.agent.services.ngreporting.ConfidenceLevel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
public class Rule
extends PolicyNode {
    boolean enabled = true;
    boolean unique;
    boolean observable;
    List<String> hashComponents;
    String id;
    String name;
    String category;
    ConfidenceLevel level;
    Set<Tag> disallowedTags = Collections.emptySet();
    EventPattern pattern;
    List<e> deadzones = Collections.emptyList();

    public Rule(int n2) {
        super(n2);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        Objects.requireNonNull(string, () -> "Rule ID cannot be null parameter cannot be null");
        this.id = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public ConfidenceLevel getLevel() {
        return this.level;
    }

    public void setLevel(ConfidenceLevel confidenceLevel) {
        this.level = confidenceLevel;
    }

    public Set<Tag> getDisallowedTags() {
        return this.disallowedTags;
    }

    public void setDisallowedTags(Set<Tag> set) {
        if (set == null) {
            this.disallowedTags = Collections.emptySet();
            return;
        }
        this.disallowedTags = set;
    }

    public EventPattern getEventPattern() {
        return this.pattern;
    }

    public void setEventPattern(EventPattern eventPattern) {
        this.pattern = eventPattern;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public void setObservable(boolean bl2) {
        this.observable = bl2;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public List<String> getHashComponents() {
        return this.hashComponents;
    }

    public void setHashComponents(List<String> list) {
        this.hashComponents = list;
    }

    public List<e> getDeadzones() {
        return this.deadzones;
    }

    public void setDeadzones(List<e> list) {
        if (list == null) {
            return;
        }
        this.deadzones = list;
    }

    public boolean requiresDataFlow() {
        Event[] eventArray;
        if (this.pattern != null && (eventArray = this.pattern.getEvents()) != null) {
            for (Event event : eventArray) {
                Parameter[] parameterArray;
                Set<Tag> set = event.getRequiredObjectTags();
                if (set != null && !set.isEmpty()) {
                    return true;
                }
                ParameterList parameterList = event.getParameterList();
                if (parameterList == null || (parameterArray = parameterList.getParameters()) == null) continue;
                for (Parameter parameter : parameterArray) {
                    if (!parameter.requiresTracking()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public k getMethodMatcher() {
        throw new UnsupportedOperationException("rule parent nodes have no matching mechanism");
    }

    @Override
    public boolean isSignatureBased() {
        return false;
    }

    @Override
    protected String getTypeLabel() {
        return "rule";
    }
}

