/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.sources;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.instr.ContrastMethod;
import com.contrastsecurity.agent.plugins.security.policy.PolicyNode;
import com.contrastsecurity.agent.plugins.security.policy.k;
import com.contrastsecurity.agent.plugins.security.policy.sources.AbstractClassMatcher;
import com.contrastsecurity.agent.plugins.security.policy.sources.IMethodExcluder;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.ToStringBuilder;
import java.lang.reflect.Modifier;

@DontObfuscate
public class DynamicSource
extends PolicyNode {
    private String id;
    AbstractClassMatcher[] matchers;
    IMethodExcluder[] excluders;
    private k matcher;

    public DynamicSource(int n2, String string) {
        super(n2);
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public AbstractClassMatcher[] getMatchers() {
        return this.matchers;
    }

    public void setMatchers(AbstractClassMatcher[] abstractClassMatcherArray) {
        this.matchers = abstractClassMatcherArray;
    }

    public IMethodExcluder[] getExcluders() {
        return this.excluders;
    }

    public void setExcluders(IMethodExcluder[] iMethodExcluderArray) {
        this.excluders = iMethodExcluderArray;
    }

    public boolean match(ContrastMethod contrastMethod) {
        for (AbstractClassMatcher abstractClassMatcher : this.matchers) {
            if (Modifier.isAbstract(contrastMethod.getFlags()) && !abstractClassMatcher.shouldIncludeStatic() || !contrastMethod.getMethodName().startsWith("set") || !abstractClassMatcher.matches(contrastMethod.getDeclaringClass())) continue;
            for (IMethodExcluder iMethodExcluder : this.excluders) {
                if (!iMethodExcluder.shouldExclude(contrastMethod)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getTypeLabel() {
        return "dynamic-source";
    }

    @Override
    public boolean isSignatureBased() {
        return false;
    }

    @Override
    public k getMethodMatcher() {
        return this.matcher;
    }

    public String toString() {
        return new ToStringBuilder(this).append("matchers", this.matchers).append("excluders", this.excluders).toString();
    }
}

