/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.reflection;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;

@m
@DontObfuscate
public final class ContrastReflectionDispatcherImpl
implements ContrastReflectionDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(ContrastReflectionDispatcherImpl.class);

    @ScopedSensor
    public Object invokeMethod(Object object, String string) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            if (object == null || StringUtils.isBlank(string)) {
                scopeAggregator.leaveScope();
                return null;
            }
            Object object2 = Reflect.reflect(object, logger).invoke(string).asNullable(Object.class);
            scopeAggregator.leaveScope();
            return object2;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public Object getField(Object object, String string) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            if (object == null || StringUtils.isBlank(string)) {
                scopeAggregator.leaveScope();
                return null;
            }
            Object object2 = Reflect.reflect(object, logger).field(string).asNullable(Object.class);
            scopeAggregator.leaveScope();
            return object2;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }
}

