/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.reflection;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public final class ReflectCache {
    private final Map<Class<?>, Map<String, Map<Integer, Method>>> methods = new ConcurrentReferenceHashMap(16, 0.75f, 64);
    private final Map<Class<?>, Map<String, Field>> fields = new ConcurrentReferenceHashMap(16, 0.75f, 64);
    private static final ReflectCache INSTANCE = new ReflectCache();
    private static final Object FNF_FIELD = null;
    private static final Field FIELD_NOT_FOUND;
    private static final Method METHOD_NOT_FOUND;

    private ReflectCache() {
    }

    public Method getMethod(Class<?> clazz2, String string2, Class<?>[] classArray, boolean bl2, Object ... objectArray) {
        int n2;
        Objects.requireNonNull(classArray, "Unable to reflect with a null argType array");
        if (objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Argument lengths between argTypes and args do not match");
        }
        Map map = this.methods.computeIfAbsent(clazz2, clazz -> new ConcurrentHashMap());
        Map map2 = map.computeIfAbsent(string2, string -> new ConcurrentHashMap());
        Method method = (Method)map2.get(n2 = Arrays.hashCode(classArray));
        if (method == null) {
            Method method2 = method = bl2 ? a.b(clazz2, string2, classArray) : a.a(clazz2, string2, classArray);
            if (method == null) {
                method = METHOD_NOT_FOUND;
            }
            map2.put(n2, method);
        }
        if (method == METHOD_NOT_FOUND) {
            return null;
        }
        return method;
    }

    public Field getField(Class<?> clazz2, String string, boolean bl2) {
        Map map = this.fields.computeIfAbsent(clazz2, clazz -> new ConcurrentHashMap());
        Field field = (Field)map.get(string);
        if (field == null) {
            Field field2 = field = bl2 ? a.c(clazz2, string) : a.a(clazz2, string);
            if (field == null) {
                field = FIELD_NOT_FOUND;
            }
            map.put(string, field);
        }
        if (field == FIELD_NOT_FOUND) {
            return null;
        }
        return field;
    }

    @o
    Map<Class<?>, Map<String, Map<Integer, Method>>> getMethods() {
        return this.methods;
    }

    @o
    Map<Class<?>, Map<String, Field>> getFields() {
        return this.fields;
    }

    static ReflectCache getInstance() {
        return INSTANCE;
    }

    private static void mnfMethod() {
    }

    static {
        try {
            METHOD_NOT_FOUND = ReflectCache.class.getDeclaredMethod("mnfMethod", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        try {
            FIELD_NOT_FOUND = ReflectCache.class.getDeclaredField("FNF_FIELD");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }
}

