/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Iterators;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.TagRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class TagRanges
implements b<TagRanges>,
Iterable<TagRange> {
    @HeapUsage.Deep
    private final List<TagRange> tags;

    public TagRanges() {
        this.tags = new ArrayList<TagRange>();
    }

    public TagRanges(List<TagRange> list) {
        this.tags = new ArrayList<TagRange>(list);
        this.mergeTags();
    }

    public TagRanges(List<TagRange> list, Collection<Tag> collection) {
        this.tags = new ArrayList<TagRange>(list);
        this.untag(collection);
        this.mergeTags();
    }

    public TagRanges(TagRange tagRange) {
        this.tags = new ArrayList<TagRange>();
        this.tags.add(tagRange);
    }

    public void untag(Collection<Tag> collection) {
        if (collection == null || collection.isEmpty() || this.tags.isEmpty()) {
            return;
        }
        this.tags.removeIf(tagRange -> collection.contains((Object)tagRange.getTag()));
    }

    @Deprecated
    @o
    public TagRanges add(TagRange tagRange) {
        this.tags.add(tagRange);
        return this.mergeTags();
    }

    public TagRanges shift(int n2) {
        if (n2 == 0) {
            return this;
        }
        for (TagRange tagRange : this.tags) {
            if (tagRange.start + n2 < 0 || tagRange.stop + n2 < 0) {
                throw new InvalidTagRangeException("Attempt to shift range into negative territory detected. Delta is " + n2 + ". " + this.toString());
            }
            tagRange.start += n2;
            tagRange.stop += n2;
        }
        return this;
    }

    public TagRanges clear(int n2, int n3) {
        if (n2 < 0 || n2 > n3) {
            throw new InvalidTagRangeException("Attempt to clear invalid range " + n2 + " to " + n3 + " on " + this.toString());
        }
        Iterator<TagRange> iterator = this.tags.iterator();
        TagRange tagRange = null;
        while (iterator.hasNext()) {
            TagRange tagRange2 = iterator.next();
            switch (tagRange2.compareRange(n2, n3)) {
                case a: {
                    break;
                }
                case b: {
                    tagRange2.stop = n2;
                    break;
                }
                case c: {
                    iterator.remove();
                    break;
                }
                case d: {
                    TagRange tagRange3 = tagRange2.copy();
                    tagRange2.stop = n2;
                    tagRange3.start = n3;
                    tagRange = tagRange3;
                    break;
                }
                case e: {
                    tagRange2.start = n3;
                    break;
                }
            }
        }
        if (tagRange != null) {
            this.tags.add(tagRange);
            this.mergeTags();
        }
        return this;
    }

    public TagRanges remove(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to remove invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to remove invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        Iterator<TagRange> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: {
                    break;
                }
                case b: {
                    tagRange.stop = n2;
                    break;
                }
                case c: {
                    iterator.remove();
                    break;
                }
                case d: {
                    tagRange.stop -= n4;
                    break;
                }
                case e: {
                    tagRange.start = n2;
                    tagRange.stop -= n3 - tagRange.start;
                    break;
                }
                case f: {
                    tagRange.start -= n4;
                    tagRange.stop -= n4;
                }
            }
        }
        return this;
    }

    public TagRanges insert(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        for (TagRange tagRange : this.tags) {
            if (n2 > tagRange.stop) continue;
            if (n2 >= tagRange.start && n2 < tagRange.stop) {
                tagRange.stop += n4;
                continue;
            }
            if (n2 >= tagRange.start) continue;
            tagRange.start += n4;
            tagRange.stop += n4;
        }
        return this;
    }

    public TagRanges split(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>();
        for (TagRange tagRange : this.tags) {
            if (n2 > tagRange.stop) continue;
            if (n2 > tagRange.start && n2 < tagRange.stop) {
                TagRange tagRange2 = new TagRange(n3, tagRange.stop + n4, tagRange.getTag());
                arrayList.add(tagRange2);
                tagRange.stop = n2;
                continue;
            }
            if (n2 > tagRange.start) continue;
            tagRange.start += n4;
            tagRange.stop += n4;
        }
        this.tags.addAll(arrayList);
        this.mergeTags();
        return this;
    }

    public TagRanges trim(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            this.tags.clear();
            return this;
        }
        Iterator<TagRange> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: 
                case f: {
                    iterator.remove();
                    break;
                }
                case b: {
                    tagRange.start = 0;
                    tagRange.stop -= n2;
                    break;
                }
                case c: {
                    tagRange.start -= n2;
                    tagRange.stop -= n2;
                    break;
                }
                case d: {
                    tagRange.start = 0;
                    tagRange.stop = n3 - n2;
                    break;
                }
                case e: {
                    tagRange.start -= n2;
                    tagRange.stop = n3 - n2;
                }
            }
        }
        return this;
    }

    public TagRanges subRange(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            this.tags.clear();
        }
        Iterator<TagRange> iterator = this.tags.iterator();
        block3: while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: 
                case f: {
                    iterator.remove();
                    continue block3;
                }
            }
            tagRange.start = Math.max(tagRange.start, n2);
            tagRange.stop = Math.min(tagRange.stop, n3);
        }
        return this;
    }

    public TagRanges explode(int n2) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to explode to a negative length");
        }
        for (TagRange tagRange : this.tags) {
            tagRange.start = 0;
            tagRange.stop = n2;
        }
        return this;
    }

    public List<TagRange> getUntrustedRanges() {
        LinkedList<TagRange> linkedList = new LinkedList<TagRange>();
        for (TagRange tagRange : this.tags) {
            if (Tag.UNTRUSTED != tagRange.getTag()) continue;
            linkedList.add(tagRange);
        }
        return linkedList;
    }

    public boolean hasUntrustedRanges() {
        for (TagRange tagRange : this.tags) {
            if (Tag.UNTRUSTED != tagRange.getTag()) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> getRangeBoundaries() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TagRange tagRange : this.tags) {
            treeSet.add(tagRange.getStart());
            treeSet.add(tagRange.getStop());
        }
        return treeSet;
    }

    public List<TagRange> getTagRanges() {
        return Collections.unmodifiableList(this.tags);
    }

    public Set<Tag> getTags() {
        EnumSet<Tag> enumSet = EnumSet.noneOf(Tag.class);
        for (TagRange tagRange : this.tags) {
            enumSet.add(tagRange.getTag());
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public Set<Tag> getTagsAt(int n2) {
        EnumSet<Tag> enumSet = EnumSet.noneOf(Tag.class);
        for (TagRange tagRange : this.tags) {
            if (tagRange.start > n2 || tagRange.stop <= n2) continue;
            enumSet.add(tagRange.getTag());
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public List<EventTaintRangeDTM> toDTM() {
        HashMap<Tag, EventTaintRangeDTM> hashMap = new HashMap<Tag, EventTaintRangeDTM>();
        for (TagRange tagRange : this.tags) {
            Tag tag = tagRange.getTag();
            EventTaintRangeDTM eventTaintRangeDTM = (EventTaintRangeDTM)hashMap.get((Object)tag);
            String string = eventTaintRangeDTM == null ? tagRange.start + ":" + tagRange.stop : eventTaintRangeDTM.getRange() + ',' + tagRange.start + ':' + tagRange.stop;
            EventTaintRangeDTM eventTaintRangeDTM2 = new EventTaintRangeDTM(tag, string);
            hashMap.put(tag, eventTaintRangeDTM2);
        }
        return Collections.unmodifiableList(new ArrayList(hashMap.values()));
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public TagRanges copy() {
        return new TagRanges(this.copyAsList());
    }

    public List<TagRange> copyAsList() {
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>(this.tags.size());
        for (TagRange tagRange : this.tags) {
            arrayList.add(tagRange.copy());
        }
        return arrayList;
    }

    @Override
    public Iterator<TagRange> iterator() {
        return Iterators.unmodifiable(this.tags);
    }

    public String toString() {
        return "Tags:" + this.tags;
    }

    public String toString(Object object) {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (TagRange tagRange : this.tags) {
            stringBuilder.append(tagRange.toString(object));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private TagRanges mergeTags() {
        for (int i2 = this.tags.size() - 1; i2 >= 0; --i2) {
            TagRange tagRange = this.tags.get(i2);
            for (int i3 = this.tags.size() - 1; i3 >= 0; --i3) {
                TagRange tagRange2;
                if (i3 == i2 || !tagRange.overlaps(tagRange2 = this.tags.get(i3))) continue;
                tagRange.merge(tagRange2);
                this.tags.remove(i3);
                if (i2 <= this.tags.size() - 1) continue;
                i2 = this.tags.size();
            }
        }
        return this;
    }
}

