/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.trace.snapshot.a;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;

@DontObfuscate
public final class SnapshotFactory {
    private final e config;
    private final int maxAssessSnapshotCacheSize;
    private final int maxSnapshotToStringLength;
    private static final String LM_CACHE = "AssessContextCache";
    private static final Logger logger = LoggerFactory.getLogger(SnapshotFactory.class);

    public SnapshotFactory(e e2) {
        this.config = e2;
        this.maxAssessSnapshotCacheSize = e2.getInt(ConfigProperty.MAX_CONTEXT_SNAPSHOT_CACHE_SIZE);
        this.maxSnapshotToStringLength = e2.getInt(ConfigProperty.MAX_SNAPSHOT_TOSTRING_LENGTH);
    }

    public String snapshot(AssessmentContext assessmentContext, Object object, EventActionDTM eventActionDTM) {
        return this.snapshot(assessmentContext != null ? assessmentContext.getSnapshotCache() : a.a, object, eventActionDTM);
    }

    @o
    public String snapshot(a a2, Object object, EventActionDTM eventActionDTM) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Boolean || object instanceof Number) {
            return object.toString();
        }
        if (this.useMinimalSnapshot(eventActionDTM)) {
            return JVMUtils.getSafeToString(object);
        }
        String string = this.calculateToStringSnapshot(object, a2);
        if (string != null) {
            return string;
        }
        return JVMUtils.getSafeToString(object);
    }

    private boolean useMinimalSnapshot(EventActionDTM eventActionDTM) {
        if (eventActionDTM == null) {
            return false;
        }
        ServerSettingsAssessDTM.EventDetailEnum eventDetailEnum = ServerSettingsAssessDTM.EventDetailEnum.findByName(this.config.get(ConfigProperty.EVENT_DETAIL));
        switch (eventActionDTM) {
            case CREATION: {
                return eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.SINK || eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.OFF;
            }
            case TRIGGER: {
                return eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.OFF;
            }
        }
        return eventDetailEnum != ServerSettingsAssessDTM.EventDetailEnum.FULL;
    }

    private String calculateToStringSnapshot(Object object, a a2) {
        if (!SnapshotFactory.shouldUseToString(object)) {
            return null;
        }
        String string = a2.getSnapshot(object);
        if (string != null) {
            this.logCacheHit(object);
            return string;
        }
        this.logCacheMiss(object);
        int n2 = this.estimateLength(object);
        if (n2 >= this.maxSnapshotToStringLength || n2 == 0) {
            return null;
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        String string2 = object.toString();
        int n3 = string2.length();
        if (n3 <= this.maxSnapshotToStringLength && n3 > 0) {
            string = string2;
            if (SnapshotFactory.shouldCache(object) && a2.cacheEntries() < this.maxAssessSnapshotCacheSize) {
                a2.putSnapshot(object, string);
            }
            return string;
        }
        return null;
    }

    private int estimateLength(Object object) {
        int n2 = -1;
        if (object instanceof String) {
            n2 = ((String)object).length();
        } else if (object instanceof StringBuilder) {
            n2 = ((StringBuilder)object).length();
        } else if (object instanceof StringBuffer) {
            n2 = ((StringBuffer)object).length();
        } else if (object instanceof CharBuffer) {
            n2 = ((CharBuffer)object).length();
        } else if (object instanceof char[]) {
            n2 = ((char[])object).length;
        }
        return n2;
    }

    static boolean shouldUseToString(Object object) {
        return SnapshotFactory.shouldCache(object) || object instanceof StringBuilder || object instanceof StringBuffer || object instanceof CharBuffer || object instanceof char[];
    }

    public static boolean shouldCache(Object object) {
        return object instanceof String || object instanceof URI || object instanceof URL || object instanceof Character || object instanceof Number && StringUtils.startsWith(object.getClass().getName(), "java") || object != null && object.getClass() == File.class;
    }

    private void logCacheHit(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&value={}", LM_CACHE, "Hit", "Snapshot", JVMUtils.getSafeToString(object));
        }
    }

    private void logCacheMiss(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&type={}&value={}", LM_CACHE, "Miss", "Snapshot", object.getClass().getName(), JVMUtils.getSafeToString(object));
        }
    }
}

