/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.google.protobuf.ExtensionSchemas;
import com.contrastsecurity.thirdparty.com.google.protobuf.GeneratedMessageInfoFactory;
import com.contrastsecurity.thirdparty.com.google.protobuf.GeneratedMessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.ListFieldSchema;
import com.contrastsecurity.thirdparty.com.google.protobuf.MapFieldSchemas;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageInfo;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageInfoFactory;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageSchema;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageSetSchema;
import com.contrastsecurity.thirdparty.com.google.protobuf.NewInstanceSchemas;
import com.contrastsecurity.thirdparty.com.google.protobuf.ProtoSyntax;
import com.contrastsecurity.thirdparty.com.google.protobuf.Schema;
import com.contrastsecurity.thirdparty.com.google.protobuf.SchemaFactory;
import com.contrastsecurity.thirdparty.com.google.protobuf.SchemaUtil;

final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        this.messageInfoFactory = Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
    }

    @Override
    public <T> Schema<T> createSchema(Class<T> clazz) {
        SchemaUtil.requireGeneratedMessage(clazz);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(clazz);
        if (messageInfo.isMessageSetWireFormat()) {
            if (GeneratedMessageLite.class.isAssignableFrom(clazz)) {
                return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
            }
            return MessageSetSchema.newSchema(SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(clazz, messageInfo);
    }

    private static <T> Schema<T> newSchema(Class<T> clazz, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom(clazz)) {
            return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite()) : MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
        }
        return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full()) : MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
    }

    private static boolean isProto2(MessageInfo messageInfo) {
        return messageInfo.getSyntax() == ProtoSyntax.PROTO2;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Class<?> clazz = Class.forName("com.contrastsecurity.thirdparty.com.google.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return EMPTY_FACTORY;
        }
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        CompositeMessageInfoFactory(MessageInfoFactory ... messageInfoFactoryArray) {
            this.factories = messageInfoFactoryArray;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            for (MessageInfoFactory messageInfoFactory : this.factories) {
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            for (MessageInfoFactory messageInfoFactory : this.factories) {
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return messageInfoFactory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + clazz.getName());
        }
    }
}

