/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteBufferWriter;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteOutput;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.RopeByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.Utf8;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

final class NioByteString
extends ByteString.LeafByteString {
    private final ByteBuffer buffer;

    NioByteString(ByteBuffer byteBuffer) {
        Internal.checkNotNull(byteBuffer, "buffer");
        this.buffer = byteBuffer.slice().order(ByteOrder.nativeOrder());
    }

    private Object writeReplace() {
        return ByteString.copyFrom(this.buffer.slice());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("NioByteString instances are not to be serialized directly");
    }

    @Override
    public byte byteAt(int n2) {
        try {
            return this.buffer.get(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public byte internalByteAt(int n2) {
        return this.byteAt(n2);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public ByteString substring(int n2, int n3) {
        try {
            ByteBuffer byteBuffer = this.slice(n2, n3);
            return new NioByteString(byteBuffer);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n2, int n3, int n4) {
        ByteBuffer byteBuffer = this.buffer.slice();
        ((Buffer)byteBuffer).position(n2);
        byteBuffer.get(byArray, n3, n4);
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.buffer.slice());
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    @Override
    boolean equalsRange(ByteString byteString, int n2, int n3) {
        return this.substring(0, n3).equals(byteString.substring(n2, n2 + n3));
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n2, int n3) throws IOException {
        if (this.buffer.hasArray()) {
            int n4 = this.buffer.arrayOffset() + this.buffer.position() + n2;
            outputStream.write(this.buffer.array(), n4, n3);
            return;
        }
        ByteBufferWriter.write(this.slice(n2, n2 + n3), outputStream);
    }

    @Override
    void writeTo(ByteOutput byteOutput) throws IOException {
        byteOutput.writeLazy(this.buffer.slice());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    protected String toStringInternal(Charset charset) {
        int n2;
        int n3;
        byte[] byArray;
        if (this.buffer.hasArray()) {
            byArray = this.buffer.array();
            n3 = this.buffer.arrayOffset() + this.buffer.position();
            n2 = this.buffer.remaining();
        } else {
            byArray = this.toByteArray();
            n3 = 0;
            n2 = byArray.length;
        }
        return new String(byArray, n3, n2, charset);
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }

    @Override
    protected int partialIsValidUtf8(int n2, int n3, int n4) {
        return Utf8.partialIsValidUtf8(n2, this.buffer, n3, n3 + n4);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.size() != byteString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (object instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)object).buffer);
        }
        if (object instanceof RopeByteString) {
            return object.equals(this);
        }
        return this.buffer.equals(byteString.asReadOnlyByteBuffer());
    }

    @Override
    protected int partialHash(int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            n2 = n2 * 31 + this.buffer.get(i2);
        }
        return n2;
    }

    @Override
    public InputStream newInput() {
        return new InputStream(){
            private final ByteBuffer buf;
            {
                this.buf = NioByteString.this.buffer.slice();
            }

            @Override
            public void mark(int n2) {
                this.buf.mark();
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public void reset() throws IOException {
                try {
                    this.buf.reset();
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IOException(invalidMarkException);
                }
            }

            @Override
            public int available() throws IOException {
                return this.buf.remaining();
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                n3 = Math.min(n3, this.buf.remaining());
                this.buf.get(byArray, n2, n3);
                return n3;
            }
        };
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private ByteBuffer slice(int n2, int n3) {
        if (n2 < this.buffer.position() || n3 > this.buffer.limit() || n2 > n3) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", n2, n3));
        }
        ByteBuffer byteBuffer = this.buffer.slice();
        ((Buffer)byteBuffer).position(n2 - this.buffer.position());
        ((Buffer)byteBuffer).limit(n3 - this.buffer.position());
        return byteBuffer;
    }
}

