/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SocketFrameHandler
implements FrameHandler {
    private final Socket _socket;
    private final ExecutorService _shutdownExecutor;
    private final DataInputStream _inputStream;
    private final DataOutputStream _outputStream;
    public static final int SOCKET_CLOSING_TIMEOUT = 1;

    public SocketFrameHandler(Socket socket) throws IOException {
        this(socket, null);
    }

    public SocketFrameHandler(Socket socket, ExecutorService executorService) throws IOException {
        this._socket = socket;
        this._shutdownExecutor = executorService;
        this._inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this._outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    @Override
    public InetAddress getAddress() {
        return this._socket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public DataInputStream getInputStream() {
        return this._inputStream;
    }

    @Override
    public int getPort() {
        return this._socket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    @Override
    public void setTimeout(int n2) throws SocketException {
        this._socket.setSoTimeout(n2);
    }

    @Override
    public int getTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int n2, int n3) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(1);
            this._outputStream.write(1);
            this._outputStream.write(n2);
            this._outputStream.write(n3);
            this._outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int n2, int n3, int n4) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(0);
            this._outputStream.write(n2);
            this._outputStream.write(n3);
            this._outputStream.write(n4);
            this._outputStream.flush();
        }
    }

    @Override
    public void sendHeader() throws IOException {
        this.sendHeader(0, 9, 1);
    }

    @Override
    public void initialize(AMQConnection aMQConnection) {
        aMQConnection.startMainLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame readFrame() throws IOException {
        DataInputStream dataInputStream = this._inputStream;
        synchronized (dataInputStream) {
            return Frame.readFrom(this._inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFrame(Frame frame) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            frame.writeTo(this._outputStream);
        }
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
    }

    @Override
    public void close() {
        Exception exception;
        block8: {
            Object object;
            try {
                this._socket.setSoLinger(true, 1);
            }
            catch (Exception exception2) {
                Throwables.throwIfCritical(exception2);
                object = exception2;
            }
            object = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SocketFrameHandler.this.flush();
                    return null;
                }
            };
            Future future = null;
            try {
                if (this._shutdownExecutor == null) {
                    object.call();
                } else {
                    future = this._shutdownExecutor.submit(object);
                    future.get(1L, TimeUnit.SECONDS);
                }
            }
            catch (Exception exception3) {
                Throwables.throwIfCritical(exception3);
                exception = exception3;
                if (future == null) break block8;
                future.cancel(true);
            }
        }
        try {
            this._socket.close();
        }
        catch (Exception exception4) {
            Throwables.throwIfCritical(exception4);
            exception = exception4;
        }
    }
}

