/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TruncatedInputStream
extends FilterInputStream {
    private final long limit;
    private long counter = 0L;
    private long mark = 0L;

    public TruncatedInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.limit = l2;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.limit - this.counter, (long)super.available());
    }

    @Override
    public synchronized void mark(int n2) {
        super.mark(n2);
        this.mark = this.counter;
    }

    @Override
    public int read() throws IOException {
        if (this.counter < this.limit) {
            int n2 = super.read();
            if (n2 >= 0) {
                ++this.counter;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.limit > this.counter) {
            int n4 = super.read(byArray, n2, (int)Math.min((long)n3, this.limit - this.counter));
            if (n4 > 0) {
                this.counter += (long)n4;
            }
            return n4;
        }
        return -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.counter = this.mark;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = super.skip(Math.min(l2, this.limit - this.counter));
        this.counter += l3;
        return l3;
    }
}

