/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.HighCardinalityTagsDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterFilter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterFilterReply;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.NamingConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.NoPauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopTimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search.RequiredSearch;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search.Search;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public abstract class MeterRegistry {
    protected final Clock clock;
    private final Object meterMapLock = new Object();
    private volatile MeterFilter[] filters = new MeterFilter[0];
    private final List<Consumer<Meter>> meterAddedListeners = new CopyOnWriteArrayList<Consumer<Meter>>();
    private final List<Consumer<Meter>> meterRemovedListeners = new CopyOnWriteArrayList<Consumer<Meter>>();
    private final List<BiConsumer<Meter.Id, String>> meterRegistrationFailedListeners = new CopyOnWriteArrayList<BiConsumer<Meter.Id, String>>();
    private final Config config = new Config();
    private final More more = new More();
    private final Map<Meter.Id, Meter> meterMap = new ConcurrentHashMap<Meter.Id, Meter>();
    private final Map<Meter.Id, Set<Meter.Id>> syntheticAssociations = new HashMap<Meter.Id, Set<Meter.Id>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private PauseDetector pauseDetector = new NoPauseDetector();
    @Nullable
    private HighCardinalityTagsDetector highCardinalityTagsDetector;
    private NamingConvention namingConvention = NamingConvention.snakeCase;

    protected MeterRegistry(Clock clock) {
        Objects.requireNonNull(clock);
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, @Nullable T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    @Deprecated
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        throw new UnsupportedOperationException("MeterRegistry implementations may still override this, but it is only invoked by the overloaded form of newLongTaskTimer for backwards compatibility.");
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return this.newLongTaskTimer(id);
    }

    protected abstract Timer newTimer(Meter.Id var1, DistributionStatisticConfig var2, PauseDetector var3);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, DistributionStatisticConfig var2, double var3);

    protected abstract Meter newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected <T> TimeGauge newTimeGauge(Meter.Id id, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
        final Meter.Id id2 = id.withBaseUnit(this.getBaseTimeUnitStr());
        final Gauge gauge = this.newGauge(id2, t2, object -> TimeUtils.convert(toDoubleFunction.applyAsDouble(object), timeUnit, this.getBaseTimeUnit()));
        return new TimeGauge(){

            @Override
            public Meter.Id getId() {
                return id2;
            }

            @Override
            public double value() {
                return gauge.value();
            }

            @Override
            public TimeUnit baseTimeUnit() {
                return MeterRegistry.this.getBaseTimeUnit();
            }
        };
    }

    protected abstract <T> FunctionTimer newFunctionTimer(Meter.Id var1, T var2, ToLongFunction<T> var3, ToDoubleFunction<T> var4, TimeUnit var5);

    protected abstract <T> FunctionCounter newFunctionCounter(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected List<Tag> getConventionTags(Meter.Id id) {
        return id.getConventionTags(this.config().namingConvention());
    }

    protected String getConventionName(Meter.Id id) {
        return id.getConventionName(this.config().namingConvention());
    }

    protected abstract TimeUnit getBaseTimeUnit();

    protected abstract DistributionStatisticConfig defaultHistogramConfig();

    private String getBaseTimeUnitStr() {
        return this.getBaseTimeUnit().toString().toLowerCase();
    }

    Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, this::newCounter, NoopCounter::new);
    }

    <T> Gauge gauge(Meter.Id id2, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return this.registerMeterIfNecessary(Gauge.class, id2, id -> this.newGauge((Meter.Id)id, t2, toDoubleFunction), NoopGauge::new);
    }

    Timer timer(Meter.Id id2, DistributionStatisticConfig distributionStatisticConfig2, PauseDetector pauseDetector) {
        return this.registerMeterIfNecessary(Timer.class, id2, distributionStatisticConfig2, (id, distributionStatisticConfig) -> {
            Meter.Id id2 = id.withBaseUnit(this.getBaseTimeUnitStr());
            return this.newTimer(id2, distributionStatisticConfig.merge(this.defaultHistogramConfig()), pauseDetector);
        }, NoopTimer::new);
    }

    DistributionSummary summary(Meter.Id id2, DistributionStatisticConfig distributionStatisticConfig2, double d2) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id2, distributionStatisticConfig2, (id, distributionStatisticConfig) -> this.newDistributionSummary((Meter.Id)id, distributionStatisticConfig.merge(this.defaultHistogramConfig()), d2), NoopDistributionSummary::new);
    }

    Meter register(Meter.Id id2, Meter.Type type, Iterable<Measurement> iterable) {
        return this.registerMeterIfNecessary(Meter.class, id2, id -> this.newMeter((Meter.Id)id, type, iterable), NoopMeter::new);
    }

    public List<Meter> getMeters() {
        return Collections.unmodifiableList(new ArrayList<Meter>(this.meterMap.values()));
    }

    public void forEachMeter(Consumer<? super Meter> consumer) {
        this.meterMap.values().forEach(consumer);
    }

    public Config config() {
        return this.config;
    }

    public Search find(String string) {
        return Search.in(this).name(string);
    }

    public RequiredSearch get(String string) {
        return RequiredSearch.in(this).name(string);
    }

    public Counter counter(String string, Iterable<Tag> iterable) {
        return Counter.builder(string).tags(iterable).register(this);
    }

    public Counter counter(String string, String ... stringArray) {
        return this.counter(string, Tags.of(stringArray));
    }

    public DistributionSummary summary(String string, Iterable<Tag> iterable) {
        return DistributionSummary.builder(string).tags(iterable).register(this);
    }

    public DistributionSummary summary(String string, String ... stringArray) {
        return this.summary(string, Tags.of(stringArray));
    }

    public Timer timer(String string, Iterable<Tag> iterable) {
        return ((Timer.Builder)Timer.builder(string).tags((Iterable)iterable)).register(this);
    }

    public Timer timer(String string, String ... stringArray) {
        return this.timer(string, Tags.of(stringArray));
    }

    public More more() {
        return this.more;
    }

    @Nullable
    public <T> T gauge(String string, Iterable<Tag> iterable, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        Gauge.builder(string, t2, toDoubleFunction).tags(iterable).register(this);
        return t2;
    }

    @Nullable
    public <T extends Number> T gauge(String string, Iterable<Tag> iterable, T t2) {
        return (T)this.gauge(string, iterable, t2, Number::doubleValue);
    }

    @Nullable
    public <T extends Number> T gauge(String string, T t2) {
        return this.gauge(string, Collections.emptyList(), t2);
    }

    @Nullable
    public <T> T gauge(String string, T t2, ToDoubleFunction<T> toDoubleFunction) {
        return this.gauge(string, Collections.emptyList(), t2, toDoubleFunction);
    }

    @Nullable
    public <T extends Collection<?>> T gaugeCollectionSize(String string, Iterable<Tag> iterable, T t2) {
        return (T)this.gauge(string, iterable, t2, Collection::size);
    }

    @Nullable
    public <T extends Map<?, ?>> T gaugeMapSize(String string, Iterable<Tag> iterable, T t2) {
        return (T)this.gauge(string, iterable, t2, Map::size);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> clazz, Meter.Id id2, Function<Meter.Id, M> function, Function<Meter.Id, M> function2) {
        return (M)this.registerMeterIfNecessary(clazz, id2, null, (id, distributionStatisticConfig) -> (Meter)function.apply((Meter.Id)id), function2);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> clazz, Meter.Id id, @Nullable DistributionStatisticConfig distributionStatisticConfig, BiFunction<Meter.Id, DistributionStatisticConfig, M> biFunction, Function<Meter.Id, M> function) {
        Meter.Id id2 = this.getMappedId(id);
        Meter meter = this.getOrCreateMeter(distributionStatisticConfig, biFunction, id, id2, function);
        if (!clazz.isInstance(meter)) {
            throw new IllegalArgumentException(String.format("There is already a registered meter of a different type (%s vs. %s) with the same name: %s", meter.getClass().getSimpleName(), clazz.getSimpleName(), id.getName()));
        }
        return (M)((Meter)clazz.cast(meter));
    }

    private Meter.Id getMappedId(Meter.Id id) {
        if (id.syntheticAssociation() != null) {
            return id;
        }
        Meter.Id id2 = id;
        for (MeterFilter meterFilter : this.filters) {
            id2 = meterFilter.map(id2);
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meter getOrCreateMeter(@Nullable DistributionStatisticConfig distributionStatisticConfig, BiFunction<Meter.Id, DistributionStatisticConfig, ? extends Meter> biFunction, Meter.Id id2, Meter.Id id3, Function<Meter.Id, ? extends Meter> function) {
        Meter meter = this.meterMap.get(id3);
        if (meter == null) {
            if (this.isClosed()) {
                return function.apply(id3);
            }
            Object object = this.meterMapLock;
            synchronized (object) {
                meter = this.meterMap.get(id3);
                if (meter == null) {
                    if (!this.accept(id3)) {
                        return function.apply(id3);
                    }
                    if (distributionStatisticConfig != null) {
                        for (MeterFilter meterFilter : this.filters) {
                            DistributionStatisticConfig distributionStatisticConfig2 = meterFilter.configure(id3, distributionStatisticConfig);
                            if (distributionStatisticConfig2 == null) continue;
                            distributionStatisticConfig = distributionStatisticConfig2;
                        }
                    }
                    meter = biFunction.apply(id3, distributionStatisticConfig);
                    Meter.Id id4 = id3.syntheticAssociation();
                    if (id4 != null) {
                        Set set = this.syntheticAssociations.computeIfAbsent(id4, id -> new HashSet());
                        set.add(id3);
                    }
                    for (Consumer<Meter> consumer : this.meterAddedListeners) {
                        consumer.accept(meter);
                    }
                    this.meterMap.put(id3, meter);
                }
            }
        }
        return meter;
    }

    private boolean accept(Meter.Id id) {
        for (MeterFilter meterFilter : this.filters) {
            MeterFilterReply meterFilterReply = meterFilter.accept(id);
            if (meterFilterReply == MeterFilterReply.DENY) {
                return false;
            }
            if (meterFilterReply != MeterFilterReply.ACCEPT) continue;
            return true;
        }
        return true;
    }

    @Nullable
    @Incubating(since="1.1.0")
    public Meter remove(Meter meter) {
        return this.remove(meter.getId());
    }

    @Nullable
    @Incubating(since="1.3.16")
    public Meter removeByPreFilterId(Meter.Id id) {
        return this.remove(this.getMappedId(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Incubating(since="1.1.0")
    public Meter remove(Meter.Id id) {
        Meter meter = this.meterMap.get(id);
        if (meter != null) {
            Object object = this.meterMapLock;
            synchronized (object) {
                meter = this.meterMap.remove(id);
                if (meter != null) {
                    Set<Meter.Id> set = this.syntheticAssociations.remove(id);
                    if (set != null) {
                        for (Meter.Id object2 : set) {
                            this.remove(object2);
                        }
                    }
                    for (Consumer consumer : this.meterRemovedListeners) {
                        consumer.accept(meter);
                    }
                    return meter;
                }
            }
        }
        return null;
    }

    @Incubating(since="1.2.0")
    public void clear() {
        this.meterMap.keySet().forEach(this::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object object = this.meterMapLock;
            synchronized (object) {
                for (Meter meter : this.meterMap.values()) {
                    meter.close();
                }
            }
        }
        if (this.highCardinalityTagsDetector != null) {
            this.highCardinalityTagsDetector.close();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    protected void meterRegistrationFailed(Meter.Id id, @Nullable String string) {
        for (BiConsumer<Meter.Id, String> biConsumer : this.meterRegistrationFailedListeners) {
            biConsumer.accept(id, string);
        }
    }

    static /* synthetic */ MeterFilter[] access$002(MeterRegistry meterRegistry, MeterFilter[] meterFilterArray) {
        meterRegistry.filters = meterFilterArray;
        return meterFilterArray;
    }

    public class Config {
        public Config commonTags(Iterable<Tag> iterable) {
            return this.meterFilter(MeterFilter.commonTags(iterable));
        }

        public Config commonTags(String ... stringArray) {
            return this.commonTags(Tags.of(stringArray));
        }

        public synchronized Config meterFilter(MeterFilter meterFilter) {
            MeterFilter[] meterFilterArray = new MeterFilter[MeterRegistry.this.filters.length + 1];
            System.arraycopy(MeterRegistry.this.filters, 0, meterFilterArray, 0, MeterRegistry.this.filters.length);
            meterFilterArray[((MeterRegistry)MeterRegistry.this).filters.length] = meterFilter;
            MeterRegistry.access$002(MeterRegistry.this, meterFilterArray);
            return this;
        }

        public Config onMeterAdded(Consumer<Meter> consumer) {
            MeterRegistry.this.meterAddedListeners.add(consumer);
            return this;
        }

        @Incubating(since="1.1.0")
        public Config onMeterRemoved(Consumer<Meter> consumer) {
            MeterRegistry.this.meterRemovedListeners.add(consumer);
            return this;
        }

        @Incubating(since="1.6.0")
        public Config onMeterRegistrationFailed(BiConsumer<Meter.Id, String> biConsumer) {
            MeterRegistry.this.meterRegistrationFailedListeners.add(biConsumer);
            return this;
        }

        public Config namingConvention(NamingConvention namingConvention) {
            MeterRegistry.this.namingConvention = namingConvention;
            return this;
        }

        public NamingConvention namingConvention() {
            return MeterRegistry.this.namingConvention;
        }

        public Clock clock() {
            return MeterRegistry.this.clock;
        }

        public Config pauseDetector(PauseDetector pauseDetector) {
            MeterRegistry.this.pauseDetector = pauseDetector;
            return this;
        }

        public PauseDetector pauseDetector() {
            return MeterRegistry.this.pauseDetector;
        }

        public Config withHighCardinalityTagsDetector() {
            return this.withHighCardinalityTagsDetector(new HighCardinalityTagsDetector(MeterRegistry.this));
        }

        public Config withHighCardinalityTagsDetector(long l2, Duration duration) {
            return this.withHighCardinalityTagsDetector(new HighCardinalityTagsDetector(MeterRegistry.this, l2, duration));
        }

        private Config withHighCardinalityTagsDetector(HighCardinalityTagsDetector highCardinalityTagsDetector) {
            if (MeterRegistry.this.highCardinalityTagsDetector != null) {
                MeterRegistry.this.highCardinalityTagsDetector.close();
            }
            MeterRegistry.this.highCardinalityTagsDetector = highCardinalityTagsDetector;
            MeterRegistry.this.highCardinalityTagsDetector.start();
            return this;
        }

        @Nullable
        public HighCardinalityTagsDetector highCardinalityTagsDetector() {
            return MeterRegistry.this.highCardinalityTagsDetector;
        }
    }

    public class More {
        public LongTaskTimer longTaskTimer(String string, String ... stringArray) {
            return this.longTaskTimer(string, Tags.of(stringArray));
        }

        public LongTaskTimer longTaskTimer(String string, Iterable<Tag> iterable) {
            return LongTaskTimer.builder(string).tags(iterable).register(MeterRegistry.this);
        }

        LongTaskTimer longTaskTimer(Meter.Id id2, DistributionStatisticConfig distributionStatisticConfig2) {
            return (LongTaskTimer)MeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id2, distributionStatisticConfig2, (id, distributionStatisticConfig) -> {
                Meter.Id id2 = id.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newLongTaskTimer(id2, distributionStatisticConfig.merge(MeterRegistry.this.defaultHistogramConfig()));
            }, NoopLongTaskTimer::new);
        }

        public <T> FunctionCounter counter(String string, Iterable<Tag> iterable, T t2, ToDoubleFunction<T> toDoubleFunction) {
            return FunctionCounter.builder(string, t2, toDoubleFunction).tags(iterable).register(MeterRegistry.this);
        }

        public <T extends Number> FunctionCounter counter(String string, Iterable<Tag> iterable, T t2) {
            return FunctionCounter.builder(string, t2, Number::doubleValue).tags(iterable).register(MeterRegistry.this);
        }

        <T> FunctionCounter counter(Meter.Id id2, T t2, ToDoubleFunction<T> toDoubleFunction) {
            return (FunctionCounter)MeterRegistry.this.registerMeterIfNecessary(FunctionCounter.class, id2, id -> MeterRegistry.this.newFunctionCounter((Meter.Id)id, t2, toDoubleFunction), NoopFunctionCounter::new);
        }

        public <T> FunctionTimer timer(String string, Iterable<Tag> iterable, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
            return FunctionTimer.builder(string, t2, toLongFunction, toDoubleFunction, timeUnit).tags(iterable).register(MeterRegistry.this);
        }

        <T> FunctionTimer timer(Meter.Id id2, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
            return (FunctionTimer)MeterRegistry.this.registerMeterIfNecessary(FunctionTimer.class, id2, id -> {
                Meter.Id id2 = id.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newFunctionTimer(id2, t2, toLongFunction, toDoubleFunction, timeUnit);
            }, NoopFunctionTimer::new);
        }

        public <T> TimeGauge timeGauge(String string, Iterable<Tag> iterable, T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
            return TimeGauge.builder(string, t2, timeUnit, toDoubleFunction).tags(iterable).register(MeterRegistry.this);
        }

        <T> TimeGauge timeGauge(Meter.Id id2, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
            return (TimeGauge)MeterRegistry.this.registerMeterIfNecessary(TimeGauge.class, id2, id -> MeterRegistry.this.newTimeGauge((Meter.Id)id, t2, timeUnit, toDoubleFunction), NoopTimeGauge::new);
        }
    }
}

