/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class MockClock
implements Clock {
    private long timeNanos = (long)TimeUtils.millisToUnit(1.0, TimeUnit.NANOSECONDS);

    @Override
    public long monotonicTime() {
        return this.timeNanos;
    }

    @Override
    public long wallTime() {
        return TimeUnit.MILLISECONDS.convert(this.timeNanos, TimeUnit.NANOSECONDS);
    }

    public long add(long l2, TimeUnit timeUnit) {
        this.timeNanos += timeUnit.toNanos(l2);
        return this.timeNanos;
    }

    public long add(Duration duration) {
        return this.add(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public long addSeconds(long l2) {
        return this.add(l2, TimeUnit.SECONDS);
    }

    public static MockClock clock(MeterRegistry meterRegistry) {
        return (MockClock)meterRegistry.config().clock();
    }
}

