/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToLongFunction;

@NonNullApi
@NonNullFields
public class CaffeineCacheMetrics<K, V, C extends Cache<K, V>>
extends CacheMeterBinder<C> {
    private static final String DESCRIPTION_CACHE_LOAD = "The number of times cache lookup methods have successfully loaded a new value or failed to load a new value, either because no value was found or an exception was thrown while loading";

    public CaffeineCacheMetrics(C c2, String string, Iterable<Tag> iterable) {
        super(c2, string, iterable);
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, String ... stringArray) {
        return CaffeineCacheMetrics.monitor(meterRegistry, c2, string, Tags.of(stringArray));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, Iterable<Tag> iterable) {
        new CaffeineCacheMetrics<K, V, C>(c2, string, iterable).bindTo(meterRegistry);
        return c2;
    }

    public static <K, V, C extends AsyncCache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, String ... stringArray) {
        return CaffeineCacheMetrics.monitor(meterRegistry, c2, string, Tags.of(stringArray));
    }

    public static <K, V, C extends AsyncCache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, Iterable<Tag> iterable) {
        CaffeineCacheMetrics.monitor(meterRegistry, c2.synchronous(), string, iterable);
        return c2;
    }

    @Override
    protected Long size() {
        return this.getOrDefault(Cache::estimatedSize, null);
    }

    @Override
    protected long hitCount() {
        return this.getOrDefault((C cache) -> cache.stats().hitCount(), 0L);
    }

    @Override
    protected Long missCount() {
        return this.getOrDefault((C cache) -> cache.stats().missCount(), null);
    }

    @Override
    protected Long evictionCount() {
        return this.getOrDefault((C cache) -> cache.stats().evictionCount(), null);
    }

    @Override
    protected long putCount() {
        return this.getOrDefault((C cache) -> cache.stats().loadCount(), 0L);
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry meterRegistry) {
        Cache cache2 = (Cache)this.getCache();
        FunctionCounter.builder("cache.eviction.weight", cache2, cache -> cache.stats().evictionWeight()).tags(this.getTagsWithCacheName()).description("The sum of weights of evicted entries. This total does not include manual invalidations.").register(meterRegistry);
        if (cache2 instanceof LoadingCache) {
            TimeGauge.builder("cache.load.duration", cache2, TimeUnit.NANOSECONDS, cache -> cache.stats().totalLoadTime()).tags(this.getTagsWithCacheName()).description("The time the cache has spent loading new values").register(meterRegistry);
            FunctionCounter.builder("cache.load", cache2, cache -> cache.stats().loadSuccessCount()).tags(this.getTagsWithCacheName()).tags("result", "success").description(DESCRIPTION_CACHE_LOAD).register(meterRegistry);
            FunctionCounter.builder("cache.load", cache2, cache -> cache.stats().loadFailureCount()).tags(this.getTagsWithCacheName()).tags("result", "failure").description(DESCRIPTION_CACHE_LOAD).register(meterRegistry);
        }
    }

    @Nullable
    private Long getOrDefault(Function<C, Long> function, @Nullable Long l2) {
        Cache cache = (Cache)this.getCache();
        if (cache != null) {
            return function.apply(cache);
        }
        return l2;
    }

    private long getOrDefault(ToLongFunction<C> toLongFunction, long l2) {
        Cache cache = (Cache)this.getCache();
        if (cache != null) {
            return toLongFunction.applyAsLong(cache);
        }
        return l2;
    }
}

