/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValues;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNull;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.DefaultOkHttpObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationDocumentation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpObservationInterceptor
implements Interceptor {
    private final ObservationRegistry registry;
    private OkHttpObservationConvention observationConvention;
    private final String requestMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<KeyValue> extraTags;
    private final Iterable<BiFunction<Request, Response, KeyValue>> contextSpecificTags;
    private final Iterable<KeyValue> unknownRequestTags;
    private final boolean includeHostTag;

    public OkHttpObservationInterceptor(ObservationRegistry observationRegistry, OkHttpObservationConvention okHttpObservationConvention, String string, Function<Request, String> function, Iterable<KeyValue> iterable, Iterable<BiFunction<Request, Response, KeyValue>> iterable2, Iterable<String> iterable3, boolean bl2) {
        this.registry = observationRegistry;
        this.observationConvention = okHttpObservationConvention;
        this.requestMetricName = string;
        this.urlMapper = function;
        this.extraTags = iterable;
        this.contextSpecificTags = iterable2;
        this.includeHostTag = bl2;
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        for (String string2 : iterable3) {
            arrayList.add(KeyValue.of(string2, "UNKNOWN"));
        }
        this.unknownRequestTags = arrayList;
    }

    public static Builder builder(ObservationRegistry observationRegistry, String string) {
        return new Builder(observationRegistry, string);
    }

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        OkHttpContext okHttpContext = new OkHttpContext(this.urlMapper, this.extraTags, this.contextSpecificTags, this.unknownRequestTags, this.includeHostTag, request);
        okHttpContext.setCarrier(builder);
        okHttpContext.setState(new CallState(builder.build()));
        Observation observation = OkHttpObservationDocumentation.DEFAULT.observation(this.observationConvention, new DefaultOkHttpObservationConvention(this.requestMetricName), okHttpContext, this.registry).start();
        Request request2 = builder.build();
        CallState callState = new CallState(request2);
        okHttpContext.setState(callState);
        try {
            Response response = chain.proceed(request2);
            okHttpContext.setResponse(response);
            callState.response = response;
            Response response2 = response;
            return response2;
        }
        catch (IOException iOException) {
            callState.exception = iOException;
            observation.error(iOException);
            throw iOException;
        }
        finally {
            observation.stop();
        }
    }

    public void setObservationConvention(OkHttpObservationConvention okHttpObservationConvention) {
        this.observationConvention = okHttpObservationConvention;
    }

    public static class Builder {
        public static final String URI_PATTERN = "URI_PATTERN";
        private final String name;
        private final ObservationRegistry registry;
        private Function<Request, String> uriMapper = request -> Optional.ofNullable(request.header(URI_PATTERN)).orElse("none");
        private KeyValues tags = KeyValues.empty();
        private Collection<BiFunction<Request, Response, KeyValue>> contextSpecificTags = new ArrayList<BiFunction<Request, Response, KeyValue>>();
        private boolean includeHostTag = true;
        private Iterable<String> requestTagKeys = Collections.emptyList();
        private OkHttpObservationConvention observationConvention;

        Builder(ObservationRegistry observationRegistry, String string) {
            this.registry = observationRegistry;
            this.name = string;
        }

        public Builder tags(Iterable<KeyValue> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder observationConvention(OkHttpObservationConvention okHttpObservationConvention) {
            this.observationConvention = okHttpObservationConvention;
            return this;
        }

        public Builder tag(KeyValue keyValue) {
            this.tags = this.tags.and(keyValue);
            return this;
        }

        public Builder tag(BiFunction<Request, Response, KeyValue> biFunction) {
            this.contextSpecificTags.add(biFunction);
            return this;
        }

        public Builder uriMapper(Function<Request, String> function) {
            this.uriMapper = function;
            return this;
        }

        public Builder includeHostTag(boolean bl2) {
            this.includeHostTag = bl2;
            return this;
        }

        public Builder requestTagKeys(String ... stringArray) {
            return this.requestTagKeys(Arrays.asList(stringArray));
        }

        public Builder requestTagKeys(Iterable<String> iterable) {
            this.requestTagKeys = iterable;
            return this;
        }

        public OkHttpObservationInterceptor build() {
            return new OkHttpObservationInterceptor(this.registry, this.observationConvention, this.name, this.uriMapper, this.tags, this.contextSpecificTags, this.requestTagKeys, this.includeHostTag);
        }
    }

    static class CallState {
        @Nullable
        final Request request;
        @Nullable
        Response response;
        @Nullable
        IOException exception;

        CallState(@Nullable Request request) {
            this.request = request;
        }
    }
}

