/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.system;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NonNullApi
@NonNullFields
public class FileDescriptorMetrics
implements MeterBinder {
    private static final List<String> UNIX_OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.UnixOperatingSystemMXBean");
    private final OperatingSystemMXBean osBean;
    private final Iterable<Tag> tags;
    @Nullable
    private final Class<?> osBeanClass;
    @Nullable
    private final Method openFilesMethod;
    @Nullable
    private final Method maxFilesMethod;

    public FileDescriptorMetrics() {
        this(Collections.emptyList());
    }

    public FileDescriptorMetrics(Iterable<Tag> iterable) {
        this(ManagementFactory.getOperatingSystemMXBean(), iterable);
    }

    FileDescriptorMetrics(OperatingSystemMXBean operatingSystemMXBean, Iterable<Tag> iterable) {
        this.osBean = operatingSystemMXBean;
        this.tags = iterable;
        this.osBeanClass = this.getFirstClassFound(UNIX_OPERATING_SYSTEM_BEAN_CLASS_NAMES);
        this.openFilesMethod = this.detectMethod("getOpenFileDescriptorCount");
        this.maxFilesMethod = this.detectMethod("getMaxFileDescriptorCount");
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        if (this.openFilesMethod != null) {
            Gauge.builder("process.files.open", this.osBean, operatingSystemMXBean -> this.invoke(this.openFilesMethod)).tags(this.tags).description("The open file descriptor count").baseUnit("files").register(meterRegistry);
        }
        if (this.maxFilesMethod != null) {
            Gauge.builder("process.files.max", this.osBean, operatingSystemMXBean -> this.invoke(this.maxFilesMethod)).tags(this.tags).description("The maximum file descriptor count").baseUnit("files").register(meterRegistry);
        }
    }

    private double invoke(@Nullable Method method) {
        try {
            return method != null ? (double)((Long)method.invoke((Object)this.osBean, new Object[0])).longValue() : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return Double.NaN;
        }
    }

    @Nullable
    private Method detectMethod(String string) {
        if (this.osBeanClass == null) {
            return null;
        }
        try {
            this.osBeanClass.cast(this.osBean);
            return this.osBeanClass.getDeclaredMethod(string, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return null;
        }
    }

    @Nullable
    private Class<?> getFirstClassFound(List<String> list) {
        for (String string : list) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

