/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.system;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
public class UptimeMetrics
implements MeterBinder {
    private final RuntimeMXBean runtimeMXBean;
    private final Iterable<Tag> tags;

    public UptimeMetrics() {
        this(Collections.emptyList());
    }

    public UptimeMetrics(Iterable<Tag> iterable) {
        this(ManagementFactory.getRuntimeMXBean(), iterable);
    }

    UptimeMetrics(RuntimeMXBean runtimeMXBean, Iterable<Tag> iterable) {
        this.runtimeMXBean = runtimeMXBean;
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        TimeGauge.builder("process.uptime", this.runtimeMXBean, TimeUnit.MILLISECONDS, RuntimeMXBean::getUptime).tags(this.tags).description("The uptime of the Java virtual machine").register(meterRegistry);
        TimeGauge.builder("process.start.time", this.runtimeMXBean, TimeUnit.MILLISECONDS, RuntimeMXBean::getStartTime).tags(this.tags).description("Start time of the process since unix epoch.").register(meterRegistry);
    }
}

