/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterFilterReply;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface MeterFilter {
    public static MeterFilter commonTags(final Iterable<Tag> iterable) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                return id.replaceTags(Tags.concat((Iterable<? extends Tag>)iterable, id.getTagsAsIterable()));
            }
        };
    }

    public static MeterFilter renameTag(final String string, final String string2, final String string3) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                if (!id.getName().startsWith(string)) {
                    return id;
                }
                ArrayList<Tag> arrayList = new ArrayList<Tag>();
                for (Tag tag : id.getTagsAsIterable()) {
                    if (tag.getKey().equals(string2)) {
                        arrayList.add(Tag.of(string3, tag.getValue()));
                        continue;
                    }
                    arrayList.add(tag);
                }
                return id.replaceTags(arrayList);
            }
        };
    }

    public static MeterFilter ignoreTags(final String ... stringArray) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> list = StreamSupport.stream(id.getTagsAsIterable().spliterator(), false).filter(tag -> {
                    for (String string : stringArray) {
                        if (!tag.getKey().equals(string)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                return id.replaceTags(list);
            }
        };
    }

    public static MeterFilter replaceTagValues(final String string, final Function<String, String> function, final String ... stringArray) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> list = StreamSupport.stream(id.getTagsAsIterable().spliterator(), false).map((? super T tag) -> {
                    if (!tag.getKey().equals(string)) {
                        return tag;
                    }
                    for (String string2 : stringArray) {
                        if (!tag.getValue().equals(string2)) continue;
                        return tag;
                    }
                    return Tag.of(string, (String)function.apply(tag.getValue()));
                }).collect(Collectors.toList());
                return id.replaceTags(list);
            }
        };
    }

    public static MeterFilter denyUnless(final Predicate<Meter.Id> predicate) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return predicate.test(id) ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
            }
        };
    }

    public static MeterFilter accept(final Predicate<Meter.Id> predicate) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return predicate.test(id) ? MeterFilterReply.ACCEPT : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter deny(final Predicate<Meter.Id> predicate) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return predicate.test(id) ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter accept() {
        return MeterFilter.accept(id -> true);
    }

    public static MeterFilter deny() {
        return MeterFilter.deny(id -> true);
    }

    public static MeterFilter maximumAllowableMetrics(final int n2) {
        return new MeterFilter(){
            private final Set<Meter.Id> ids = ConcurrentHashMap.newKeySet();

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                if (this.ids.size() > n2) {
                    return MeterFilterReply.DENY;
                }
                this.ids.add(id);
                return this.ids.size() > n2 ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter maximumAllowableTags(final String string, final String string2, final int n2, final MeterFilter meterFilter) {
        return new MeterFilter(){
            private final Set<String> observedTagValues = ConcurrentHashMap.newKeySet();

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                String string3 = this.matchNameAndGetTagValue(id);
                if (string3 != null && !this.observedTagValues.contains(string3)) {
                    if (this.observedTagValues.size() >= n2) {
                        return meterFilter.accept(id);
                    }
                    this.observedTagValues.add(string3);
                }
                return MeterFilterReply.NEUTRAL;
            }

            @Nullable
            private String matchNameAndGetTagValue(Meter.Id id) {
                return id.getName().startsWith(string) ? id.getTag(string2) : null;
            }

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                String string3 = this.matchNameAndGetTagValue(id);
                if (string3 != null && !this.observedTagValues.contains(string3) && this.observedTagValues.size() >= n2) {
                    return meterFilter.configure(id, distributionStatisticConfig);
                }
                return distributionStatisticConfig;
            }
        };
    }

    public static MeterFilter denyNameStartsWith(String string) {
        return MeterFilter.deny(id -> id.getName().startsWith(string));
    }

    public static MeterFilter acceptNameStartsWith(String string) {
        return MeterFilter.accept(id -> id.getName().startsWith(string));
    }

    public static MeterFilter maxExpected(final String string, final Duration duration) {
        return new MeterFilter(){

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                if (id.getType() == Meter.Type.TIMER && id.getName().startsWith(string)) {
                    return DistributionStatisticConfig.builder().maximumExpectedValue(Double.valueOf(duration.toNanos())).build().merge(distributionStatisticConfig);
                }
                return distributionStatisticConfig;
            }
        };
    }

    @Deprecated
    public static MeterFilter maxExpected(String string, long l2) {
        return MeterFilter.maxExpected(string, (double)l2);
    }

    public static MeterFilter maxExpected(final String string, final double d2) {
        return new MeterFilter(){

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                if (id.getType() == Meter.Type.DISTRIBUTION_SUMMARY && id.getName().startsWith(string)) {
                    return DistributionStatisticConfig.builder().maximumExpectedValue(d2).build().merge(distributionStatisticConfig);
                }
                return distributionStatisticConfig;
            }
        };
    }

    public static MeterFilter minExpected(final String string, final Duration duration) {
        return new MeterFilter(){

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                if (id.getType() == Meter.Type.TIMER && id.getName().startsWith(string)) {
                    return DistributionStatisticConfig.builder().minimumExpectedValue(Double.valueOf(duration.toNanos())).build().merge(distributionStatisticConfig);
                }
                return distributionStatisticConfig;
            }
        };
    }

    @Deprecated
    public static MeterFilter minExpected(String string, long l2) {
        return MeterFilter.minExpected(string, (double)l2);
    }

    public static MeterFilter minExpected(final String string, final double d2) {
        return new MeterFilter(){

            @Override
            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                if (id.getType() == Meter.Type.DISTRIBUTION_SUMMARY && id.getName().startsWith(string)) {
                    return DistributionStatisticConfig.builder().minimumExpectedValue(d2).build().merge(distributionStatisticConfig);
                }
                return distributionStatisticConfig;
            }
        };
    }

    default public MeterFilterReply accept(Meter.Id id) {
        return MeterFilterReply.NEUTRAL;
    }

    default public Meter.Id map(Meter.Id id) {
        return id;
    }

    @Nullable
    default public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return distributionStatisticConfig;
    }
}

