/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public final class HistogramSnapshot {
    private static final ValueAtPercentile[] EMPTY_VALUES = new ValueAtPercentile[0];
    private static final CountAtBucket[] EMPTY_COUNTS = new CountAtBucket[0];
    private final ValueAtPercentile[] percentileValues;
    private final CountAtBucket[] histogramCounts;
    private final long count;
    private final double total;
    private final double max;
    @Nullable
    private final BiConsumer<PrintStream, Double> summaryOutput;

    public HistogramSnapshot(long l2, double d2, double d3, @Nullable ValueAtPercentile[] valueAtPercentileArray, @Nullable CountAtBucket[] countAtBucketArray, @Nullable BiConsumer<PrintStream, Double> biConsumer) {
        this.count = l2;
        this.total = d2;
        this.max = d3;
        this.percentileValues = valueAtPercentileArray != null ? valueAtPercentileArray : EMPTY_VALUES;
        this.histogramCounts = countAtBucketArray != null ? countAtBucketArray : EMPTY_COUNTS;
        this.summaryOutput = biConsumer;
    }

    public long count() {
        return this.count;
    }

    public double total() {
        return this.total;
    }

    public double total(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.total, timeUnit);
    }

    public double max() {
        return this.max;
    }

    public double max(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.max, timeUnit);
    }

    public double mean() {
        return this.count == 0L ? 0.0 : this.total / (double)this.count;
    }

    public double mean(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.mean(), timeUnit);
    }

    public ValueAtPercentile[] percentileValues() {
        return this.percentileValues;
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogramCounts;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HistogramSnapshot{count=");
        stringBuilder.append(this.count);
        stringBuilder.append(", total=");
        stringBuilder.append(this.total);
        stringBuilder.append(", mean=");
        stringBuilder.append(this.mean());
        stringBuilder.append(", max=");
        stringBuilder.append(this.max);
        if (this.percentileValues.length > 0) {
            stringBuilder.append(", percentileValues=");
            stringBuilder.append(Arrays.toString(this.percentileValues));
        }
        if (this.histogramCounts.length > 0) {
            stringBuilder.append(", histogramCounts=");
            stringBuilder.append(Arrays.toString(this.histogramCounts));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static HistogramSnapshot empty(long l2, double d2, double d3) {
        return new HistogramSnapshot(l2, d2, d3, null, null, null);
    }

    public void outputSummary(PrintStream printStream, double d2) {
        if (this.summaryOutput != null) {
            this.summaryOutput.accept(printStream, d2);
        }
    }
}

