/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleSupplier;

public class TimeWindowMax {
    private static final AtomicIntegerFieldUpdater<TimeWindowMax> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeWindowMax.class, "rotating");
    private final Clock clock;
    private final long durationBetweenRotatesMillis;
    private final AtomicLong[] ringBuffer;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating;

    public TimeWindowMax(Clock clock, DistributionStatisticConfig distributionStatisticConfig) {
        this(clock, distributionStatisticConfig.getExpiry().toMillis(), distributionStatisticConfig.getBufferLength());
    }

    public TimeWindowMax(Clock clock, long l2, int n2) {
        this.clock = clock;
        this.durationBetweenRotatesMillis = l2;
        this.lastRotateTimestampMillis = clock.wallTime();
        this.currentBucket = 0;
        this.ringBuffer = new AtomicLong[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.ringBuffer[i2] = new AtomicLong();
        }
    }

    public void record(double d2, TimeUnit timeUnit) {
        this.record((long)TimeUtils.convert(d2, timeUnit, TimeUnit.NANOSECONDS));
    }

    private void record(long l2) {
        this.rotate();
        for (AtomicLong atomicLong : this.ringBuffer) {
            this.updateMax(atomicLong, l2);
        }
    }

    public double poll(TimeUnit timeUnit) {
        return this.poll(() -> TimeUtils.nanosToUnit(this.ringBuffer[this.currentBucket].get(), timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double poll(DoubleSupplier doubleSupplier) {
        this.rotate();
        TimeWindowMax timeWindowMax = this;
        synchronized (timeWindowMax) {
            return doubleSupplier.getAsDouble();
        }
    }

    public double poll() {
        return this.poll(() -> Double.longBitsToDouble(this.ringBuffer[this.currentBucket].get()));
    }

    public void record(double d2) {
        this.record(Double.doubleToLongBits(d2));
    }

    private void updateMax(AtomicLong atomicLong, long l2) {
        long l3;
        while ((l3 = atomicLong.get()) < l2 && !atomicLong.compareAndSet(l3, l2)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long l2 = this.clock.wallTime();
        long l3 = l2 - this.lastRotateTimestampMillis;
        if (l3 < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            TimeWindowMax timeWindowMax = this;
            synchronized (timeWindowMax) {
                block13: {
                    if (l3 < this.durationBetweenRotatesMillis * (long)this.ringBuffer.length) break block13;
                    for (AtomicLong atomicLong : this.ringBuffer) {
                        atomicLong.set(0L);
                    }
                    this.currentBucket = 0;
                    this.lastRotateTimestampMillis = l2 - l3 % this.durationBetweenRotatesMillis;
                    return;
                }
                int n2 = 0;
                do {
                    this.ringBuffer[this.currentBucket].set(0L);
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((l3 -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis && ++n2 < this.ringBuffer.length);
            }
        }
        finally {
            this.rotating = 0;
        }
    }
}

