/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.internal;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class ReadOnlyArrayMap<K, V>
extends AbstractMap<K, V> {
    private final List<Object> array;
    private final int size;

    public static <K, V> Map<K, V> wrap(List<Object> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        return new ReadOnlyArrayMap<K, V>(list);
    }

    private ReadOnlyArrayMap(List<Object> list) {
        this.array = list;
        this.size = list.size() / 2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        return this.arrayIndexOfKey(object) != -1;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            if (!this.value(i2 + 1).equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.arrayIndexOfKey(object);
        return n2 != -1 ? (V)this.value(n2 + 1) : null;
    }

    int arrayIndexOfKey(Object object) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            if (!object.equals(this.key(i2))) continue;
            return i2;
        }
        return n2;
    }

    K key(int n2) {
        return (K)this.array.get(n2);
    }

    V value(int n2) {
        return (V)this.array.get(n2);
    }

    @Override
    public Set<K> keySet() {
        return new KeySetView();
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReadOnlyArrayMap{");
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            stringBuilder.append(this.key(i2)).append('=').append(this.value(i2 + 1));
            stringBuilder.append(',');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.append("}").toString();
    }

    final class KeySetView
    extends SetView {
        KeySetView() {
        }

        K elementAtArrayIndex(int n2) {
            return ReadOnlyArrayMap.this.key(n2);
        }

        @Override
        public boolean contains(Object object) {
            return ReadOnlyArrayMap.this.containsKey(object);
        }
    }

    final class ValuesView
    extends SetView {
        ValuesView() {
        }

        V elementAtArrayIndex(int n2) {
            return ReadOnlyArrayMap.this.value(n2 + 1);
        }

        @Override
        public boolean contains(Object object) {
            return ReadOnlyArrayMap.this.containsValue(object);
        }
    }

    final class EntrySetView
    extends SetView {
        EntrySetView() {
        }

        Map.Entry<K, V> elementAtArrayIndex(int n2) {
            return new AbstractMap.SimpleImmutableEntry(ReadOnlyArrayMap.this.key(n2), ReadOnlyArrayMap.this.value(n2 + 1));
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry) || ((Map.Entry)object).getKey() == null) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            int n2 = ReadOnlyArrayMap.this.arrayIndexOfKey(entry.getKey());
            if (n2 == -1) {
                return false;
            }
            return ReadOnlyArrayMap.this.value(n2 + 1).equals(entry.getValue());
        }
    }

    abstract class SetView<E>
    implements Set<E> {
        SetView() {
        }

        @Override
        public int size() {
            return ReadOnlyArrayMap.this.size;
        }

        abstract E elementAtArrayIndex(int var1);

        @Override
        public Iterator<E> iterator() {
            return new ReadOnlyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.copyTo(new Object[ReadOnlyArrayMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= ReadOnlyArrayMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size());
            return this.copyTo(TArray2);
        }

        <T> T[] copyTo(T[] TArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < ReadOnlyArrayMap.this.array.size(); i2 += 2) {
                TArray[n2++] = this.elementAtArrayIndex(i2);
            }
            return TArray;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            if (collection == null) {
                return false;
            }
            if (collection.isEmpty()) {
                return true;
            }
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        final class ReadOnlyIterator
        implements Iterator<E> {
            int current = 0;

            ReadOnlyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.current < ReadOnlyArrayMap.this.array.size();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e2 = SetView.this.elementAtArrayIndex(this.current);
                this.current += 2;
                return e2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

