/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorageProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorageWrappers;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.StrictContextStorage;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class LazyStorage {
    private static final String CONTEXT_STORAGE_PROVIDER_PROPERTY = "com.contrastsecurity.thirdparty.io.opentelemetry.context.contextStorageProvider";
    private static final String ENFORCE_DEFAULT_STORAGE_VALUE = "default";
    private static final String ENABLE_STRICT_CONTEXT_PROVIDER_PROPERTY = "com.contrastsecurity.thirdparty.io.opentelemetry.context.enableStrictContext";
    private static final e logger = e.a(LazyStorage.class.getName());
    private static final ContextStorage storage;

    static ContextStorage get() {
        return storage;
    }

    static ContextStorage createStorage(AtomicReference<Throwable> atomicReference) {
        String string = System.getProperty(CONTEXT_STORAGE_PROVIDER_PROPERTY, "");
        if (ENFORCE_DEFAULT_STORAGE_VALUE.equals(string)) {
            return ContextStorage.defaultStorage();
        }
        ArrayList<ContextStorageProvider> arrayList = new ArrayList<ContextStorageProvider>();
        for (ContextStorageProvider contextStorageProvider : ServiceLoader.load(ContextStorageProvider.class)) {
            if (contextStorageProvider.getClass().getName().equals("com.contrastsecurity.thirdparty.io.opentelemetry.sdk.testing.context.SettableContextStorageProvider")) {
                return contextStorageProvider.get();
            }
            arrayList.add(contextStorageProvider);
        }
        if (arrayList.isEmpty()) {
            return ContextStorage.defaultStorage();
        }
        if (string.isEmpty()) {
            if (arrayList.size() == 1) {
                return ((ContextStorageProvider)arrayList.get(0)).get();
            }
            atomicReference.set(new IllegalStateException("Found multiple ContextStorageProvider. Set the io.opentelemetry.context.ContextStorageProvider property to the fully qualified class name of the provider to use. Falling back to default ContextStorage. Found providers: " + arrayList));
            return ContextStorage.defaultStorage();
        }
        for (ContextStorageProvider contextStorageProvider : arrayList) {
            if (!contextStorageProvider.getClass().getName().equals(string)) continue;
            return contextStorageProvider.get();
        }
        atomicReference.set(new IllegalStateException("com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorageProvider property set but no matching class could be found, requested: " + string + " but found providers: " + arrayList));
        return ContextStorage.defaultStorage();
    }

    private LazyStorage() {
    }

    static {
        AtomicReference<Throwable> atomicReference = new AtomicReference<Throwable>();
        ContextStorage contextStorage = LazyStorage.createStorage(atomicReference);
        if (Boolean.getBoolean(ENABLE_STRICT_CONTEXT_PROVIDER_PROPERTY)) {
            contextStorage = StrictContextStorage.create(contextStorage);
        }
        for (Function<? super ContextStorage, ? extends ContextStorage> function : ContextStorageWrappers.getWrappers()) {
            contextStorage = function.apply(contextStorage);
        }
        storage = contextStorage;
        ContextStorageWrappers.setStorageInitialized();
        Throwable throwable = atomicReference.get();
        if (throwable != null) {
            logger.a(e.a.c, "ContextStorageProvider initialized failed. Using default", throwable);
        }
    }
}

