/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.ExporterMetrics;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcSender;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public final class GrpcExporter<T extends Marshaler> {
    private static final e internalLogger = e.a(GrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final GrpcSender<T> grpcSender;
    private final ExporterMetrics exporterMetrics;

    public GrpcExporter(String string, String string2, GrpcSender<T> grpcSender, Supplier<MeterProvider> supplier) {
        this.type = string2;
        this.grpcSender = grpcSender;
        this.exporterMetrics = ExporterMetrics.createGrpc(string, string2, supplier);
    }

    public CompletableResultCode export(T t2, int n2) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(n2);
        CompletableResultCode completableResultCode = new CompletableResultCode();
        this.grpcSender.send(t2, () -> {
            this.exporterMetrics.addSuccess(n2);
            completableResultCode.succeed();
        }, (grpcResponse, throwable) -> {
            this.exporterMetrics.addFailed(n2);
            switch (grpcResponse.grpcStatusValue()) {
                case 12: {
                    if (!this.loggedUnimplemented.compareAndSet(false, true)) break;
                    GrpcExporterUtil.logUnimplemented(internalLogger, this.type, grpcResponse.grpcStatusDescription());
                    break;
                }
                case 14: {
                    this.logger.log(e.a.b, "Failed to export " + this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + grpcResponse.grpcStatusDescription());
                    break;
                }
                default: {
                    this.logger.log(e.a.c, "Failed to export " + this.type + "s. Server responded with gRPC status code " + grpcResponse.grpcStatusValue() + ". Error message: " + grpcResponse.grpcStatusDescription());
                }
            }
            if (this.logger.isLoggable(e.a.h)) {
                this.logger.log(e.a.h, "Failed to export " + this.type + "s. Details follow: " + throwable);
            }
            completableResultCode.fail();
        });
        return completableResultCode;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(e.a.d, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.grpcSender.shutdown();
    }
}

