/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.ExporterMetrics;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpSender;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class HttpExporter<T extends Marshaler> {
    private static final e internalLogger = e.a(HttpExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final HttpSender httpSender;
    private final ExporterMetrics exporterMetrics;
    private final boolean exportAsJson;

    public HttpExporter(String string, String string2, HttpSender httpSender, Supplier<MeterProvider> supplier, boolean bl2) {
        this.type = string2;
        this.httpSender = httpSender;
        this.exporterMetrics = bl2 ? ExporterMetrics.createHttpJson(string, string2, supplier) : ExporterMetrics.createHttpProtobuf(string, string2, supplier);
        this.exportAsJson = bl2;
    }

    public CompletableResultCode export(T t2, int n2) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(n2);
        CompletableResultCode completableResultCode = new CompletableResultCode();
        Consumer<OutputStream> consumer = outputStream -> {
            try {
                if (this.exportAsJson) {
                    t2.writeJsonTo((OutputStream)outputStream);
                } else {
                    t2.writeBinaryTo((OutputStream)outputStream);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        };
        this.httpSender.send(consumer, ((Marshaler)t2).getBinarySerializedSize(), response -> {
            byte[] byArray;
            int n3 = response.statusCode();
            if (n3 >= 200 && n3 < 300) {
                this.exporterMetrics.addSuccess(n2);
                completableResultCode.succeed();
                return;
            }
            this.exporterMetrics.addFailed(n2);
            try {
                byArray = response.responseBody();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            String string = HttpExporter.extractErrorStatus(response.statusMessage(), byArray);
            this.logger.log(e.a.c, "Failed to export " + this.type + "s. Server responded with HTTP status code " + n3 + ". Error message: " + string);
            completableResultCode.fail();
        }, throwable -> {
            this.exporterMetrics.addFailed(n2);
            this.logger.log(e.a.b, "Failed to export " + this.type + "s. The request could not be executed. Full error message: " + throwable.getMessage(), (Throwable)throwable);
            completableResultCode.fail();
        });
        return completableResultCode;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(e.a.d, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.httpSender.shutdown();
    }

    private static String extractErrorStatus(String string, @Nullable byte[] byArray) {
        if (byArray == null) {
            return "Response body missing, HTTP status message: " + string;
        }
        try {
            return GrpcExporterUtil.getStatusMessage(byArray);
        }
        catch (IOException iOException) {
            return "Unable to parse response body, HTTP status message: " + string;
        }
    }
}

