/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.extension.incubator.propagation;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapGetter;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PassThroughPropagator
implements TextMapPropagator {
    private static final ContextKey<List<String>> EXTRACTED_KEY_VALUES = ContextKey.named("passthroughpropagator-keyvalues");
    private final List<String> fields;

    private PassThroughPropagator(List<String> list) {
        this.fields = Collections.unmodifiableList(list);
    }

    public static TextMapPropagator create(String ... stringArray) {
        Objects.requireNonNull(stringArray, "fields");
        return PassThroughPropagator.create(Arrays.asList(stringArray));
    }

    public static TextMapPropagator create(Iterable<String> iterable) {
        Objects.requireNonNull(iterable, "fields");
        List<String> list = StreamSupport.stream(iterable.spliterator(), false).map(string -> Objects.requireNonNull(string, "field")).collect(Collectors.toList());
        if (list.isEmpty()) {
            return TextMapPropagator.noop();
        }
        return new PassThroughPropagator(list);
    }

    @Override
    public Collection<String> fields() {
        return this.fields;
    }

    @Override
    public <C> void inject(Context context, @Nullable C c2, TextMapSetter<C> textMapSetter) {
        List<String> list = context.get(EXTRACTED_KEY_VALUES);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                textMapSetter.set(c2, list.get(i2), list.get(i2 + 1));
            }
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C c2, TextMapGetter<C> textMapGetter) {
        ArrayList<String> arrayList = null;
        for (String string : this.fields) {
            String string2 = textMapGetter.get(c2, string);
            if (string2 == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string);
            arrayList.add(string2);
        }
        return arrayList != null ? context.with(EXTRACTED_KEY_VALUES, arrayList) : context;
    }

    public String toString() {
        return "PassThroughPropagator{fields=" + this.fields + "}";
    }
}

