/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.LongHistogram;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.extension.incubator.metrics.ExtendedLongHistogramBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.extension.incubator.metrics.LongHistogramAdviceConfigurer;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final e logger = e.a(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor instrumentDescriptor, WriteableMetricStorage writeableMetricStorage) {
        super(instrumentDescriptor);
        this.storage = writeableMetricStorage;
    }

    @Override
    public void record(long l2, Attributes attributes, Context context) {
        if (l2 < 0L) {
            this.throttlingLogger.log(e.a.c, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(l2, attributes, context);
    }

    @Override
    public void record(long l2, Attributes attributes) {
        this.record(l2, attributes, Context.current());
    }

    @Override
    public void record(long l2) {
        this.record(l2, Attributes.empty());
    }

    static final class SdkLongHistogramBuilder
    extends AbstractInstrumentBuilder<SdkLongHistogramBuilder>
    implements ExtendedLongHistogramBuilder,
    LongHistogramAdviceConfigurer {
        SdkLongHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String string, String string2, String string3, Advice advice) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, string, string2, string3, advice);
        }

        @Override
        protected SdkLongHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkLongHistogramBuilder setAdvice(Consumer<LongHistogramAdviceConfigurer> consumer) {
            consumer.accept(this);
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.buildSynchronousInstrument((instrumentDescriptor, writeableMetricStorage) -> new SdkLongHistogram((InstrumentDescriptor)instrumentDescriptor, (WriteableMetricStorage)writeableMetricStorage));
        }

        @Override
        public LongHistogramAdviceConfigurer setExplicitBucketBoundaries(List<Long> list) {
            List<Double> list2 = list.stream().map(Long::doubleValue).collect(Collectors.toList());
            this.setAdvice(Advice.create(list2));
            return this;
        }
    }
}

