/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.List;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> list) {
        super(clock, list.size() + 1, new HistogramCellSelector(list), ReservoirCell::getAndResetDouble);
    }

    @Override
    public void offerLongMeasurement(long l2, Attributes attributes, Context context) {
        super.offerDoubleMeasurement(l2, attributes, context);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> list) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(list);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] reservoirCellArray, long l2, Attributes attributes, Context context) {
            return this.reservoirCellIndexFor(reservoirCellArray, (double)l2, attributes, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] reservoirCellArray, double d2, Attributes attributes, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, d2);
        }

        @Override
        public void reset() {
        }
    }
}

