/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.MatchResult;
import com.contrastsecurity.thirdparty.jregex.Matcher;
import com.contrastsecurity.thirdparty.jregex.Pattern;
import com.contrastsecurity.thirdparty.jregex.PerlSubstitution;
import com.contrastsecurity.thirdparty.jregex.Substitution;
import com.contrastsecurity.thirdparty.jregex.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class Replacer {
    private final Pattern pattern;
    private Substitution substitution;

    public Replacer(Pattern pattern, Substitution substitution) {
        this.pattern = pattern;
        this.substitution = substitution;
    }

    public Replacer(Pattern pattern, String string) {
        this(pattern, string, true);
    }

    public Replacer(Pattern pattern, String string, boolean bl2) {
        this.pattern = pattern;
        this.substitution = bl2 ? new PerlSubstitution(string) : new DummySubstitution(string);
    }

    public void setSubstitution(String string, boolean bl2) {
        this.substitution = bl2 ? new PerlSubstitution(string) : new DummySubstitution(string);
    }

    public String replace(String string) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(string.length()));
        Replacer.replace(this.pattern.matcher(string), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(char[] cArray, int n2, int n3) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(n3));
        Replacer.replace(this.pattern.matcher(cArray, n2, n3), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(MatchResult matchResult, int n2) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer());
        Replacer.replace(this.pattern.matcher(matchResult, n2), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(Reader reader, int n2) throws IOException {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(n2 >= 0 ? n2 : 0));
        Replacer.replace(this.pattern.matcher(reader, n2), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public int replace(String string, StringBuffer stringBuffer) {
        return Replacer.replace(this.pattern.matcher(string), this.substitution, Replacer.wrap(stringBuffer));
    }

    public int replace(char[] cArray, int n2, int n3, StringBuffer stringBuffer) {
        return this.replace(cArray, n2, n3, Replacer.wrap(stringBuffer));
    }

    public int replace(MatchResult matchResult, int n2, StringBuffer stringBuffer) {
        return this.replace(matchResult, n2, Replacer.wrap(stringBuffer));
    }

    public int replace(MatchResult matchResult, String string, StringBuffer stringBuffer) {
        return this.replace(matchResult, string, Replacer.wrap(stringBuffer));
    }

    public int replace(Reader reader, int n2, StringBuffer stringBuffer) throws IOException {
        return this.replace(reader, n2, Replacer.wrap(stringBuffer));
    }

    public int replace(String string, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(string), this.substitution, textBuffer);
    }

    public int replace(char[] cArray, int n2, int n3, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(cArray, n2, n3), this.substitution, textBuffer);
    }

    public int replace(MatchResult matchResult, int n2, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(matchResult, n2), this.substitution, textBuffer);
    }

    public int replace(MatchResult matchResult, String string, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(matchResult, string), this.substitution, textBuffer);
    }

    public int replace(Reader reader, int n2, TextBuffer textBuffer) throws IOException {
        return Replacer.replace(this.pattern.matcher(reader, n2), this.substitution, textBuffer);
    }

    public static int replace(Matcher matcher, Substitution substitution, TextBuffer textBuffer) {
        boolean bl2 = true;
        int n2 = 0;
        while (matcher.find()) {
            if (matcher.end() == 0 && !bl2) continue;
            if (matcher.start() > 0) {
                matcher.getGroup(-1, textBuffer);
            }
            substitution.appendSubstitution(matcher, textBuffer);
            ++n2;
            matcher.setTarget(matcher, -2);
            bl2 = false;
        }
        matcher.getGroup(-3, textBuffer);
        return n2;
    }

    public static int replace(Matcher matcher, Substitution substitution, Writer writer) throws IOException {
        try {
            return Replacer.replace(matcher, substitution, Replacer.wrap(writer));
        }
        catch (WriteException writeException) {
            throw writeException.reason;
        }
    }

    public void replace(String string, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(string), this.substitution, writer);
    }

    public void replace(char[] cArray, int n2, int n3, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(cArray, n2, n3), this.substitution, writer);
    }

    public void replace(MatchResult matchResult, int n2, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(matchResult, n2), this.substitution, writer);
    }

    public void replace(MatchResult matchResult, String string, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(matchResult, string), this.substitution, writer);
    }

    public void replace(Reader reader, int n2, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(reader, n2), this.substitution, writer);
    }

    public static TextBuffer wrap(final StringBuffer stringBuffer) {
        return new TextBuffer(){

            @Override
            public void append(char c2) {
                stringBuffer.append(c2);
            }

            @Override
            public void append(char[] cArray, int n2, int n3) {
                stringBuffer.append(cArray, n2, n3);
            }

            @Override
            public void append(String string) {
                stringBuffer.append(string);
            }

            public String toString() {
                return stringBuffer.toString();
            }
        };
    }

    public static TextBuffer wrap(final Writer writer) {
        return new TextBuffer(){

            @Override
            public void append(char c2) {
                try {
                    writer.write(c2);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }

            @Override
            public void append(char[] cArray, int n2, int n3) {
                try {
                    writer.write(cArray, n2, n3);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }

            @Override
            public void append(String string) {
                try {
                    writer.write(string);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }
        };
    }

    private static class DummySubstitution
    implements Substitution {
        String str;

        DummySubstitution(String string) {
            this.str = string;
        }

        @Override
        public void appendSubstitution(MatchResult matchResult, TextBuffer textBuffer) {
            if (this.str != null) {
                textBuffer.append(this.str);
            }
        }
    }

    private static class WriteException
    extends RuntimeException {
        IOException reason;

        WriteException(IOException iOException) {
            this.reason = iOException;
        }
    }
}

