/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.n3.nanoxml;

import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLEntityResolver;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLReader;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLParseException;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLUtil;
import java.io.IOException;
import java.io.Reader;

class ContentReader
extends Reader {
    private IXMLReader reader;
    private String buffer;
    private int bufferIndex;
    private IXMLEntityResolver resolver;

    ContentReader(IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver, String string) {
        this.reader = iXMLReader;
        this.resolver = iXMLEntityResolver;
        this.buffer = string;
        this.bufferIndex = 0;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        try {
            int n4 = 0;
            int n5 = this.buffer.length();
            if (n2 + n3 > cArray.length) {
                n3 = cArray.length - n2;
            }
            while (n4 < n3) {
                char c2;
                String string = "";
                if (this.bufferIndex < n5) {
                    c2 = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    cArray[n4] = c2;
                    ++n4;
                    continue;
                }
                string = XMLUtil.read(this.reader, '&');
                c2 = string.charAt(0);
                if (c2 == '<') {
                    this.reader.unread(c2);
                    break;
                }
                if (c2 == '&' && string.length() > 1) {
                    if (string.charAt(1) == '#') {
                        c2 = XMLUtil.processCharLiteral(string);
                    } else {
                        XMLUtil.processEntity(string, this.reader, this.resolver);
                        continue;
                    }
                }
                cArray[n4] = c2;
                ++n4;
            }
            if (n4 == 0) {
                n4 = -1;
            }
            return n4;
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            int n2 = this.buffer.length();
            while (true) {
                char c2;
                String string = "";
                if (this.bufferIndex < n2) {
                    c2 = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    continue;
                }
                string = XMLUtil.read(this.reader, '&');
                c2 = string.charAt(0);
                if (c2 == '<') {
                    this.reader.unread(c2);
                    break;
                }
                if (c2 != '&' || string.length() <= 1 || string.charAt(1) == '#') continue;
                XMLUtil.processEntity(string, this.reader, this.resolver);
            }
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }
}

