/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Join;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Select;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.update.Update;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser.LimitDeparser;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;

public class UpdateDeParser
implements OrderByVisitor {
    private StringBuilder buffer = new StringBuilder();
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();
    private SelectVisitor selectVisitor = new SelectVisitorAdapter();

    public UpdateDeParser() {
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public void deParse(Update update) {
        this.buffer.append("UPDATE ").append(PlainSelect.getStringList(update.getTables(), true, false)).append(" SET ");
        if (!update.isUseSelect()) {
            for (int i2 = 0; i2 < update.getColumns().size(); ++i2) {
                Column object2 = update.getColumns().get(i2);
                object2.accept(this.expressionVisitor);
                this.buffer.append(" = ");
                Expression expression = update.getExpressions().get(i2);
                expression.accept(this.expressionVisitor);
                if (i2 >= update.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        } else {
            if (update.isUseColumnsBrackets()) {
                this.buffer.append("(");
            }
            for (int i3 = 0; i3 < update.getColumns().size(); ++i3) {
                if (i3 != 0) {
                    this.buffer.append(", ");
                }
                Column column = update.getColumns().get(i3);
                column.accept(this.expressionVisitor);
            }
            if (update.isUseColumnsBrackets()) {
                this.buffer.append(")");
            }
            this.buffer.append(" = ");
            this.buffer.append("(");
            Select select = update.getSelect();
            select.getSelectBody().accept(this.selectVisitor);
            this.buffer.append(")");
        }
        if (update.getFromItem() != null) {
            this.buffer.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.buffer.append(", ").append(join);
                        continue;
                    }
                    this.buffer.append(" ").append(join);
                }
            }
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(update.getLimit());
        }
        if (update.isReturningAllColumns()) {
            this.buffer.append(" RETURNING *");
        } else if (update.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ");
            Iterator<SelectExpressionItem> iterator = update.getReturningExpressionList().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(OrderByElement orderByElement) {
        orderByElement.getExpression().accept(this.expressionVisitor);
        if (!orderByElement.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderByElement.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderByElement.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderByElement.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }
}

