/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.Base64Helper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public class IntCountsHistogram
extends AbstractHistogram {
    long totalCount;
    int[] counts;
    int normalizingIndexOffset;

    @Override
    long getCountAtIndex(int n2) {
        return this.counts[this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength)];
    }

    @Override
    long getCountAtNormalizedIndex(int n2) {
        return this.counts[n2];
    }

    @Override
    void incrementCountAtIndex(int n2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        int n4 = this.counts[n3];
        int n5 = n4 + 1;
        if (n5 < 0) {
            throw new IllegalStateException("would overflow integer count");
        }
        this.counts[n3] = n5;
    }

    @Override
    void addToCountAtIndex(int n2, long l2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        long l3 = this.counts[n3];
        long l4 = l3 + l2;
        if (l4 < Integer.MIN_VALUE || l4 > Integer.MAX_VALUE) {
            throw new IllegalStateException("would overflow integer count");
        }
        this.counts[n3] = (int)l4;
    }

    @Override
    void setCountAtIndex(int n2, long l2) {
        this.setCountAtNormalizedIndex(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength), l2);
    }

    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("would overflow integer count");
        }
        this.counts[n2] = (int)l2;
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.normalizingIndexOffset;
    }

    @Override
    void setNormalizingIndexOffset(int n2) {
        this.normalizingIndexOffset = n2;
    }

    @Override
    void setIntegerToDoubleValueConversionRatio(double d2) {
        this.nonConcurrentSetIntegerToDoubleValueConversionRatio(d2);
    }

    @Override
    void shiftNormalizingIndexByOffset(int n2, boolean bl2, double d2) {
        this.nonConcurrentNormalizingIndexShift(n2, bl2);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, 0);
        this.totalCount = 0L;
    }

    @Override
    public IntCountsHistogram copy() {
        IntCountsHistogram intCountsHistogram = new IntCountsHistogram(this);
        intCountsHistogram.add(this);
        return intCountsHistogram;
    }

    @Override
    public IntCountsHistogram copyCorrectedForCoordinatedOmission(long l2) {
        IntCountsHistogram intCountsHistogram = new IntCountsHistogram(this);
        intCountsHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return intCountsHistogram;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long l2) {
        this.totalCount = l2;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long l2) {
        this.totalCount += l2;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 4 * this.counts.length;
    }

    @Override
    void resize(long l2) {
        int n2 = this.normalizeIndex(0, this.normalizingIndexOffset, this.countsArrayLength);
        this.establishSize(l2);
        int n3 = this.countsArrayLength - this.counts.length;
        this.counts = Arrays.copyOf(this.counts, this.countsArrayLength);
        if (n2 != 0) {
            int n4 = n2 + n3;
            int n5 = this.countsArrayLength - n3 - n2;
            System.arraycopy(this.counts, n2, this.counts, n4, n5);
            Arrays.fill(this.counts, n2, n4, 0);
        }
    }

    public IntCountsHistogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public IntCountsHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public IntCountsHistogram(long l2, long l3, int n2) {
        super(l2, l3, n2);
        this.counts = new int[this.countsArrayLength];
        this.wordSizeInBytes = 4;
    }

    public IntCountsHistogram(AbstractHistogram abstractHistogram) {
        super(abstractHistogram);
        this.counts = new int[this.countsArrayLength];
        this.wordSizeInBytes = 4;
    }

    public static IntCountsHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return IntCountsHistogram.decodeFromByteBuffer(byteBuffer, IntCountsHistogram.class, l2);
    }

    public static IntCountsHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return IntCountsHistogram.decodeFromCompressedByteBuffer(byteBuffer, IntCountsHistogram.class, l2);
    }

    public static IntCountsHistogram fromString(String string) throws DataFormatException {
        return IntCountsHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

