/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray;

import com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray.AbstractPackedArrayContext;
import com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray.PackedArrayContext;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;

class ConcurrentPackedArrayContext
extends PackedArrayContext {
    private AtomicLongArray array;
    private volatile int populatedShortLength;
    private static final AtomicIntegerFieldUpdater<ConcurrentPackedArrayContext> populatedShortLengthUpdater = AtomicIntegerFieldUpdater.newUpdater(ConcurrentPackedArrayContext.class, "populatedShortLength");

    ConcurrentPackedArrayContext(int n2, int n3, boolean bl2) {
        super(n2, n3, false);
        if (bl2) {
            this.array = new AtomicLongArray(this.getPhysicalLength());
            this.init(n2);
        }
    }

    ConcurrentPackedArrayContext(int n2, int n3) {
        this(n2, n3, true);
    }

    ConcurrentPackedArrayContext(int n2, AbstractPackedArrayContext abstractPackedArrayContext, int n3) {
        this(n2, n3);
        if (this.isPacked()) {
            this.populateEquivalentEntriesWithZerosFromOther(abstractPackedArrayContext);
        }
    }

    @Override
    int length() {
        return this.array.length();
    }

    @Override
    int getPopulatedShortLength() {
        return this.populatedShortLength;
    }

    @Override
    boolean casPopulatedShortLength(int n2, int n3) {
        return populatedShortLengthUpdater.compareAndSet(this, n2, n3);
    }

    @Override
    boolean casPopulatedLongLength(int n2, int n3) {
        int n4 = this.getPopulatedShortLength();
        int n5 = n4 + 3 >> 2;
        if (n5 != n2) {
            return false;
        }
        return this.casPopulatedShortLength(n4, n3 << 2);
    }

    @Override
    long getAtLongIndex(int n2) {
        return this.array.get(n2);
    }

    @Override
    boolean casAtLongIndex(int n2, long l2, long l3) {
        return this.array.compareAndSet(n2, l2, l3);
    }

    @Override
    void lazySetAtLongIndex(int n2, long l2) {
        this.array.lazySet(n2, l2);
    }

    @Override
    void clearContents() {
        for (int i2 = 0; i2 < this.array.length(); ++i2) {
            this.array.lazySet(i2, 0L);
        }
        this.init(this.getVirtualLength());
    }

    @Override
    void resizeArray(int n2) {
        AtomicLongArray atomicLongArray = new AtomicLongArray(n2);
        int n3 = Math.min(this.array.length(), n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            atomicLongArray.lazySet(i2, this.array.get(i2));
        }
        this.array = atomicLongArray;
    }

    @Override
    long getAtUnpackedIndex(int n2) {
        return this.array.get(n2);
    }

    @Override
    void setAtUnpackedIndex(int n2, long l2) {
        this.array.set(n2, l2);
    }

    @Override
    void lazysetAtUnpackedIndex(int n2, long l2) {
        this.array.lazySet(n2, l2);
    }

    @Override
    long incrementAndGetAtUnpackedIndex(int n2) {
        return this.array.incrementAndGet(n2);
    }

    @Override
    long addAndGetAtUnpackedIndex(int n2, long l2) {
        return this.array.addAndGet(n2, l2);
    }

    @Override
    String unpackedToString() {
        return this.array.toString();
    }
}

