/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.digest;

import com.contrastsecurity.thirdparty.org.apache.commons.codec.binary.StringUtils;

public final class MurmurHash2 {
    private static final int M32 = 1540483477;
    private static final int R32 = 24;
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;

    private MurmurHash2() {
    }

    public static int hash32(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3 ^ n2;
        int n6 = n2 >> 2;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = n4 << 2;
            int n8 = MurmurHash2.getLittleEndianInt(byArray, n7);
            n8 *= 1540483477;
            n8 ^= n8 >>> 24;
            n5 *= 1540483477;
            n5 ^= (n8 *= 1540483477);
        }
        n4 = n6 << 2;
        switch (n2 - n4) {
            case 3: {
                n5 ^= (byArray[n4 + 2] & 0xFF) << 16;
            }
            case 2: {
                n5 ^= (byArray[n4 + 1] & 0xFF) << 8;
            }
            case 1: {
                n5 ^= byArray[n4] & 0xFF;
                n5 *= 1540483477;
            }
        }
        n5 ^= n5 >>> 13;
        n5 *= 1540483477;
        n5 ^= n5 >>> 15;
        return n5;
    }

    public static int hash32(byte[] byArray, int n2) {
        return MurmurHash2.hash32(byArray, n2, -1756908916);
    }

    public static int hash32(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash2.hash32(byArray, byArray.length);
    }

    public static int hash32(String string, int n2, int n3) {
        return MurmurHash2.hash32(string.substring(n2, n2 + n3));
    }

    public static long hash64(byte[] byArray, int n2, int n3) {
        int n4;
        long l2 = (long)n3 & 0xFFFFFFFFL ^ (long)n2 * -4132994306676758123L;
        int n5 = n2 >> 3;
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = n4 << 3;
            long l3 = MurmurHash2.getLittleEndianLong(byArray, n6);
            l3 *= -4132994306676758123L;
            l3 ^= l3 >>> 47;
            l2 ^= (l3 *= -4132994306676758123L);
            l2 *= -4132994306676758123L;
        }
        n4 = n5 << 3;
        switch (n2 - n4) {
            case 7: {
                l2 ^= ((long)byArray[n4 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l2 ^= ((long)byArray[n4 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l2 ^= ((long)byArray[n4 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l2 ^= ((long)byArray[n4 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l2 ^= ((long)byArray[n4 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l2 ^= ((long)byArray[n4 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l2 ^= (long)byArray[n4] & 0xFFL;
                l2 *= -4132994306676758123L;
            }
        }
        l2 ^= l2 >>> 47;
        l2 *= -4132994306676758123L;
        l2 ^= l2 >>> 47;
        return l2;
    }

    public static long hash64(byte[] byArray, int n2) {
        return MurmurHash2.hash64(byArray, n2, -512093083);
    }

    public static long hash64(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash2.hash64(byArray, byArray.length);
    }

    public static long hash64(String string, int n2, int n3) {
        return MurmurHash2.hash64(string.substring(n2, n2 + n3));
    }

    private static int getLittleEndianInt(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static long getLittleEndianLong(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }
}

