/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.language.bm;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.Resources;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.language.bm.Languages;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.language.bm.NameType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;

public class Lang {
    private static final Map<NameType, Lang> Langs = new EnumMap<NameType, Lang>(NameType.class);
    private static final String LANGUAGE_RULES_RN = "com/contrastsecurity/thirdparty/org/apache/commons/codec/language/bm/%s_lang.txt";
    private final Languages languages;
    private final List<LangRule> rules;

    public static Lang instance(NameType nameType) {
        return Langs.get((Object)nameType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Lang loadFromResource(String string, Languages languages) {
        Scanner scanner;
        ArrayList<LangRule> arrayList;
        block14: {
            arrayList = new ArrayList<LangRule>();
            scanner = new Scanner(Resources.getInputStream(string), "UTF-8");
            Throwable throwable = null;
            try {
                boolean bl2 = false;
                while (scanner.hasNextLine()) {
                    String string2;
                    String string3 = string2 = scanner.nextLine();
                    if (bl2) {
                        if (!string3.endsWith("*/")) continue;
                        bl2 = false;
                        continue;
                    }
                    if (string3.startsWith("/*")) {
                        bl2 = true;
                        continue;
                    }
                    int n2 = string3.indexOf("//");
                    if (n2 >= 0) {
                        string3 = string3.substring(0, n2);
                    }
                    if ((string3 = string3.trim()).length() == 0) continue;
                    String[] stringArray = string3.split("\\s+");
                    if (stringArray.length != 3) {
                        throw new IllegalArgumentException("Malformed line '" + string2 + "' in language resource '" + string + "'");
                    }
                    Pattern pattern = Pattern.compile(stringArray[0]);
                    String[] stringArray2 = stringArray[1].split("\\+");
                    boolean bl3 = stringArray[2].equals("true");
                    arrayList.add(new LangRule(pattern, new HashSet<String>(Arrays.asList(stringArray2)), bl3));
                }
                if (scanner == null) return new Lang(arrayList, languages);
                if (throwable == null) break block14;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable5;
                    Throwables.throwIfCritical(throwable2);
                    throwable = throwable5 = throwable2;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (scanner == null) throw throwable6;
                    if (throwable == null) {
                        scanner.close();
                        throw throwable6;
                    }
                    try {
                        scanner.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable8 = throwable3;
                        throwable.addSuppressed(throwable8);
                        throw throwable6;
                    }
                }
            }
            try {
                scanner.close();
                return new Lang(arrayList, languages);
            }
            catch (Throwable throwable4) {
                Throwables.throwIfCritical(throwable4);
                Throwable throwable3 = throwable4;
                throwable.addSuppressed(throwable3);
                return new Lang(arrayList, languages);
            }
        }
        scanner.close();
        return new Lang(arrayList, languages);
    }

    private Lang(List<LangRule> list, Languages languages) {
        this.rules = Collections.unmodifiableList(list);
        this.languages = languages;
    }

    public String guessLanguage(String string) {
        Languages.LanguageSet languageSet = this.guessLanguages(string);
        return languageSet.isSingleton() ? languageSet.getAny() : "any";
    }

    public Languages.LanguageSet guessLanguages(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        HashSet<String> hashSet = new HashSet<String>(this.languages.getLanguages());
        for (LangRule langRule : this.rules) {
            if (!langRule.matches(string2)) continue;
            if (langRule.acceptOnMatch) {
                hashSet.retainAll(langRule.languages);
                continue;
            }
            hashSet.removeAll(langRule.languages);
        }
        Languages.LanguageSet languageSet = Languages.LanguageSet.from(hashSet);
        return languageSet.equals(Languages.NO_LANGUAGES) ? Languages.ANY_LANGUAGE : languageSet;
    }

    static {
        for (NameType nameType : NameType.values()) {
            Langs.put(nameType, Lang.loadFromResource(String.format(LANGUAGE_RULES_RN, nameType.getName()), Languages.getInstance(nameType)));
        }
    }

    private static final class LangRule {
        private final boolean acceptOnMatch;
        private final Set<String> languages;
        private final Pattern pattern;

        private LangRule(Pattern pattern, Set<String> set, boolean bl2) {
            this.pattern = pattern;
            this.languages = set;
            this.acceptOnMatch = bl2;
        }

        public boolean matches(String string) {
            return this.pattern.matcher(string).find();
        }
    }
}

