/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.input;

import com.contrastsecurity.thirdparty.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends ProxyInputStream {
    private long count;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public synchronized long skip(long l2) throws IOException {
        long l3 = super.skip(l2);
        this.count += l3;
        return l3;
    }

    @Override
    protected synchronized void afterRead(int n2) {
        if (n2 != -1) {
            this.count += (long)n2;
        }
    }

    public int getCount() {
        long l2 = this.getByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public int resetCount() {
        long l2 = this.resetByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l2 = this.count;
        this.count = 0L;
        return l2;
    }
}

