/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumUtils {
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> clazz) {
        Objects.requireNonNull(clazz, ENUM_CLASS_MUST_BE_DEFINED);
        Validate.isTrue(clazz.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, clazz);
        return clazz;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> clazz) {
        Enum[] enumArray = (Enum[])EnumUtils.asEnum(clazz).getEnumConstants();
        Validate.isTrue(enumArray.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, enumArray.length, clazz.getSimpleName(), 64);
        return clazz;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, E ... EArray) {
        Validate.noNullElements(EArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(EArray));
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, Iterable<? extends E> iterable) {
        EnumUtils.checkBitVectorable(clazz);
        Objects.requireNonNull(iterable, "values");
        long l2 = 0L;
        for (Enum enum_ : iterable) {
            Objects.requireNonNull(enum_, NULL_ELEMENTS_NOT_PERMITTED);
            l2 |= 1L << enum_.ordinal();
        }
        return l2;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> clazz, E ... EArray) {
        EnumUtils.asEnum(clazz);
        Validate.noNullElements(EArray);
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        Collections.addAll(enumSet, EArray);
        long[] lArray = new long[(((Enum[])clazz.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum enum_ : enumSet) {
            int n2 = enum_.ordinal() / 64;
            lArray[n2] = lArray[n2] | 1L << enum_.ordinal() % 64;
        }
        ArrayUtils.reverse(lArray);
        return lArray;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> clazz, Iterable<? extends E> iterable) {
        EnumUtils.asEnum(clazz);
        Objects.requireNonNull(iterable, "values");
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        iterable.forEach(enum_ -> enumSet.add(Objects.requireNonNull(enum_, NULL_ELEMENTS_NOT_PERMITTED)));
        long[] lArray = new long[(((Enum[])clazz.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum enum_2 : enumSet) {
            int n2 = enum_2.ordinal() / 64;
            lArray[n2] = lArray[n2] | 1L << enum_2.ordinal() % 64;
        }
        ArrayUtils.reverse(lArray);
        return lArray;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string, E e2) {
        if (string == null) {
            return e2;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e2;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string, E e2) {
        return (E)EnumUtils.getFirstEnumIgnoreCase(clazz, string, Enum::name, e2);
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<Enum>(Arrays.asList((Enum[])clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> clazz) {
        return EnumUtils.getEnumMap(clazz, Enum::name);
    }

    public static <E extends Enum<E>, K> Map<K, E> getEnumMap(Class<E> clazz, Function<E, K> function) {
        return Stream.of((Enum[])clazz.getEnumConstants()).collect(Collectors.toMap(function::apply, Function.identity()));
    }

    public static <E extends Enum<E>> E getEnumSystemProperty(Class<E> clazz, String string, E e2) {
        return clazz == null || string == null ? e2 : EnumUtils.getEnum(clazz, System.getProperty(string), e2);
    }

    public static <E extends Enum<E>> E getFirstEnumIgnoreCase(Class<E> clazz, String string, Function<E, String> function, E e2) {
        if (string == null || !clazz.isEnum()) {
            return e2;
        }
        return (E)Stream.of((Enum[])clazz.getEnumConstants()).filter(enum_ -> string.equalsIgnoreCase((String)function.apply(enum_))).findFirst().orElse(e2);
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string) != null;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> clazz, long l2) {
        EnumUtils.checkBitVectorable(clazz).getEnumConstants();
        return EnumUtils.processBitVectors(clazz, l2);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> clazz, long ... lArray) {
        EnumSet<Enum> enumSet = EnumSet.noneOf(EnumUtils.asEnum(clazz));
        long[] lArray2 = ArrayUtils.clone(Objects.requireNonNull(lArray, "values"));
        ArrayUtils.reverse(lArray2);
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            int n2 = enum_.ordinal() / 64;
            if (n2 >= lArray2.length || (lArray2[n2] & 1L << enum_.ordinal() % 64) == 0L) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }

    @Deprecated
    public EnumUtils() {
    }
}

