/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent.ConcurrentException;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.concurrent.ConcurrentUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.function.FailableConsumer;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.function.FailableSupplier;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BackgroundInitializer<T>
extends AbstractConcurrentInitializer<T, Exception> {
    private ExecutorService externalExecutor;
    private ExecutorService executor;
    private Future<T> future;

    public static <T> Builder<BackgroundInitializer<T>, T> builder() {
        return new Builder();
    }

    protected BackgroundInitializer() {
        this(null);
    }

    protected BackgroundInitializer(ExecutorService executorService) {
        this.setExternalExecutor(executorService);
    }

    private BackgroundInitializer(FailableSupplier<T, ConcurrentException> failableSupplier, FailableConsumer<T, ConcurrentException> failableConsumer, ExecutorService executorService) {
        super(failableSupplier, failableConsumer);
        this.setExternalExecutor(executorService);
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getTaskCount());
    }

    private Callable<T> createTask(ExecutorService executorService) {
        return new InitializationTask(executorService);
    }

    @Override
    public T get() throws ConcurrentException {
        try {
            return this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ConcurrentUtils.handleCause(executionException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConcurrentException(interruptedException);
        }
    }

    protected final synchronized ExecutorService getActiveExecutor() {
        return this.executor;
    }

    public final synchronized ExecutorService getExternalExecutor() {
        return this.externalExecutor;
    }

    public synchronized Future<T> getFuture() {
        if (this.future == null) {
            throw new IllegalStateException("start() must be called first!");
        }
        return this.future;
    }

    protected int getTaskCount() {
        return 1;
    }

    @Override
    protected Exception getTypedException(Exception exception) {
        return new Exception(exception);
    }

    @Override
    public synchronized boolean isInitialized() {
        if (this.future == null || !this.future.isDone()) {
            return false;
        }
        try {
            this.future.get();
            return true;
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            return false;
        }
    }

    public synchronized boolean isStarted() {
        return this.future != null;
    }

    public final synchronized void setExternalExecutor(ExecutorService executorService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot set ExecutorService after start()!");
        }
        this.externalExecutor = executorService;
    }

    public synchronized boolean start() {
        if (!this.isStarted()) {
            ExecutorService executorService;
            this.executor = this.getExternalExecutor();
            if (this.executor == null) {
                this.executor = executorService = this.createExecutor();
            } else {
                executorService = null;
            }
            this.future = this.executor.submit(this.createTask(executorService));
            return true;
        }
        return false;
    }

    public static class Builder<I extends BackgroundInitializer<T>, T>
    extends AbstractConcurrentInitializer.AbstractBuilder<I, T, Builder<I, T>, Exception> {
        private ExecutorService externalExecutor;

        @Override
        public I get() {
            return (I)new BackgroundInitializer(this.getInitializer(), this.getCloser(), this.externalExecutor);
        }

        public Builder<I, T> setExternalExecutor(ExecutorService executorService) {
            this.externalExecutor = executorService;
            return (Builder)this.asThis();
        }
    }

    private final class InitializationTask
    implements Callable<T> {
        private final ExecutorService execFinally;

        InitializationTask(ExecutorService executorService) {
            this.execFinally = executorService;
        }

        @Override
        public T call() throws Exception {
            try {
                Object t2 = BackgroundInitializer.this.initialize();
                return t2;
            }
            finally {
                if (this.execFinally != null) {
                    this.execFinally.shutdown();
                }
            }
        }
    }
}

