/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.LocaleUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.time.TimeZones;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractFormatCache<F extends Format> {
    static final int NONE = -1;
    private static final ConcurrentMap<ArrayKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<ArrayKey, String>(7);
    private final ConcurrentMap<ArrayKey, F> cInstanceCache = new ConcurrentHashMap<ArrayKey, F>(7);

    AbstractFormatCache() {
    }

    static String getPatternForStyle(Integer n2, Integer n3, Locale locale) {
        Locale locale2 = LocaleUtils.toLocale(locale);
        ArrayKey arrayKey2 = new ArrayKey(n2, n3, locale2);
        return cDateTimeInstanceCache.computeIfAbsent(arrayKey2, arrayKey -> {
            try {
                DateFormat dateFormat = n2 == null ? DateFormat.getTimeInstance(n3, locale2) : (n3 == null ? DateFormat.getDateInstance(n2, locale2) : DateFormat.getDateTimeInstance(n2, n3, locale2));
                return ((SimpleDateFormat)dateFormat).toPattern();
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale2);
            }
        });
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    F getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, null, timeZone, locale);
    }

    F getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, (Integer)n3, timeZone, locale);
    }

    private F getDateTimeInstance(Integer n2, Integer n3, TimeZone timeZone, Locale locale) {
        locale = LocaleUtils.toLocale(locale);
        String string = AbstractFormatCache.getPatternForStyle(n2, n3, locale);
        return this.getInstance(string, timeZone, locale);
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String string, TimeZone timeZone, Locale locale) {
        Objects.requireNonNull(string, "pattern");
        TimeZone timeZone2 = TimeZones.toTimeZone(timeZone);
        Locale locale2 = LocaleUtils.toLocale(locale);
        ArrayKey arrayKey2 = new ArrayKey(string, timeZone2, locale2);
        return (F)this.cInstanceCache.computeIfAbsent(arrayKey2, arrayKey -> this.createInstance(string, timeZone2, locale2));
    }

    F getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n2, timeZone, locale);
    }

    private static final class ArrayKey {
        private final Object[] keys;
        private final int hashCode;

        private static int computeHashCode(Object[] objectArray) {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + Arrays.hashCode(objectArray);
            return n3;
        }

        ArrayKey(Object ... objectArray) {
            this.keys = objectArray;
            this.hashCode = ArrayKey.computeHashCode(objectArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ArrayKey arrayKey = (ArrayKey)object;
            return Arrays.deepEquals(this.keys, arrayKey.keys);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

