/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.LocaleUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.time.FastDateParser;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;

    private static Date add(Date date, int n2, int n3) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n2, n3);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int n2) {
        return DateUtils.add(date, 5, n2);
    }

    public static Date addHours(Date date, int n2) {
        return DateUtils.add(date, 11, n2);
    }

    public static Date addMilliseconds(Date date, int n2) {
        return DateUtils.add(date, 14, n2);
    }

    public static Date addMinutes(Date date, int n2) {
        return DateUtils.add(date, 12, n2);
    }

    public static Date addMonths(Date date, int n2) {
        return DateUtils.add(date, 2, n2);
    }

    public static Date addSeconds(Date date, int n2) {
        return DateUtils.add(date, 13, n2);
    }

    public static Date addWeeks(Date date, int n2) {
        return DateUtils.add(date, 3, n2);
    }

    public static Date addYears(Date date, int n2) {
        return DateUtils.add(date, 1, n2);
    }

    public static Calendar ceiling(Calendar calendar, int n2) {
        Objects.requireNonNull(calendar, "calendar");
        return DateUtils.modify((Calendar)calendar.clone(), n2, ModifyType.CEILING);
    }

    public static Date ceiling(Date date, int n2) {
        return DateUtils.modify(DateUtils.toCalendar(date), n2, ModifyType.CEILING).getTime();
    }

    public static Date ceiling(Object object, int n2) {
        Objects.requireNonNull(object, "date");
        if (object instanceof Date) {
            return DateUtils.ceiling((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.ceiling((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    private static long getFragment(Calendar calendar, int n2, TimeUnit timeUnit) {
        Objects.requireNonNull(calendar, "calendar");
        long l2 = 0L;
        int n3 = timeUnit == TimeUnit.DAYS ? 0 : 1;
        switch (n2) {
            case 1: {
                l2 += timeUnit.convert(calendar.get(6) - n3, TimeUnit.DAYS);
                break;
            }
            case 2: {
                l2 += timeUnit.convert(calendar.get(5) - n3, TimeUnit.DAYS);
                break;
            }
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l2 += timeUnit.convert(calendar.get(11), TimeUnit.HOURS);
            }
            case 11: {
                l2 += timeUnit.convert(calendar.get(12), TimeUnit.MINUTES);
            }
            case 12: {
                l2 += timeUnit.convert(calendar.get(13), TimeUnit.SECONDS);
            }
            case 13: {
                l2 += timeUnit.convert(calendar.get(14), TimeUnit.MILLISECONDS);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + n2 + " is not supported");
            }
        }
        return l2;
    }

    private static long getFragment(Date date, int n2, TimeUnit timeUnit) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFragment(calendar, n2, timeUnit);
    }

    public static long getFragmentInDays(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, TimeUnit.DAYS);
    }

    public static long getFragmentInDays(Date date, int n2) {
        return DateUtils.getFragment(date, n2, TimeUnit.DAYS);
    }

    public static long getFragmentInHours(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, TimeUnit.HOURS);
    }

    public static long getFragmentInHours(Date date, int n2) {
        return DateUtils.getFragment(date, n2, TimeUnit.HOURS);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInMilliseconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInMinutes(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, TimeUnit.MINUTES);
    }

    public static long getFragmentInMinutes(Date date, int n2) {
        return DateUtils.getFragment(date, n2, TimeUnit.MINUTES);
    }

    public static long getFragmentInSeconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, TimeUnit.SECONDS);
    }

    public static long getFragmentInSeconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, TimeUnit.SECONDS);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        Objects.requireNonNull(calendar, "cal1");
        Objects.requireNonNull(calendar2, "cal2");
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameDay(Date date, Date date2) {
        return DateUtils.isSameDay(DateUtils.toCalendar(date), DateUtils.toCalendar(date2));
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        Objects.requireNonNull(calendar, "cal1");
        Objects.requireNonNull(calendar2, "cal2");
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameInstant(Date date, Date date2) {
        Objects.requireNonNull(date, "date1");
        Objects.requireNonNull(date2, "date2");
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        Objects.requireNonNull(calendar, "cal1");
        Objects.requireNonNull(calendar2, "cal2");
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(11) == calendar2.get(11) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Iterator<Calendar> iterator(Calendar calendar, int n2) {
        Calendar calendar2;
        Calendar calendar3;
        Objects.requireNonNull(calendar, "calendar");
        int n3 = 1;
        int n4 = 7;
        block0 : switch (n2) {
            case 5: 
            case 6: {
                calendar3 = DateUtils.truncate(calendar, 2);
                calendar2 = (Calendar)calendar3.clone();
                calendar2.add(2, 1);
                calendar2.add(5, -1);
                if (n2 != 6) break;
                n3 = 2;
                n4 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar3 = DateUtils.truncate(calendar, 5);
                calendar2 = DateUtils.truncate(calendar, 5);
                switch (n2) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        n3 = 2;
                        n4 = 1;
                        break block0;
                    }
                    case 3: {
                        n3 = calendar.get(7);
                        n4 = n3 - 1;
                        break block0;
                    }
                    case 4: {
                        n3 = calendar.get(7) - 3;
                        n4 = calendar.get(7) + 3;
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n2 + " is not valid.");
            }
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        if (n4 < 1) {
            n4 += 7;
        }
        if (n4 > 7) {
            n4 -= 7;
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, -1);
        }
        while (calendar2.get(7) != n4) {
            calendar2.add(5, 1);
        }
        return new DateIterator(calendar3, calendar2);
    }

    public static Iterator<Calendar> iterator(Date date, int n2) {
        return DateUtils.iterator(DateUtils.toCalendar(date), n2);
    }

    public static Iterator<?> iterator(Object object, int n2) {
        Objects.requireNonNull(object, "calendar");
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n2);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    private static Calendar modify(Calendar calendar, int n2, ModifyType modifyType) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n2 == 14) {
            return calendar;
        }
        Date date = calendar.getTime();
        long l2 = date.getTime();
        boolean bl2 = false;
        int n3 = calendar.get(14);
        if (ModifyType.TRUNCATE == modifyType || n3 < 500) {
            l2 -= (long)n3;
        }
        if (n2 == 13) {
            bl2 = true;
        }
        int n4 = calendar.get(13);
        if (!(bl2 || ModifyType.TRUNCATE != modifyType && n4 >= 30)) {
            l2 -= (long)n4 * 1000L;
        }
        if (n2 == 12) {
            bl2 = true;
        }
        int n5 = calendar.get(12);
        if (!(bl2 || ModifyType.TRUNCATE != modifyType && n5 >= 30)) {
            l2 -= (long)n5 * 60000L;
        }
        if (date.getTime() != l2) {
            date.setTime(l2);
            calendar.setTime(date);
        }
        boolean bl3 = false;
        int[][] nArray = fields;
        int n6 = nArray.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            int[] nArray2;
            for (int n7 : nArray2 = nArray[i2]) {
                if (n7 != n2) continue;
                if (modifyType == ModifyType.CEILING || modifyType == ModifyType.ROUND && bl3) {
                    if (n2 == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                        } else {
                            calendar.add(5, -15);
                            calendar.add(2, 1);
                        }
                    } else if (n2 == 9) {
                        if (calendar.get(11) == 0) {
                            calendar.add(11, 12);
                        } else {
                            calendar.add(11, -12);
                            calendar.add(5, 1);
                        }
                    } else {
                        calendar.add(nArray2[0], 1);
                    }
                }
                return calendar;
            }
            int n8 = 0;
            int n9 = 0;
            switch (n2) {
                case 1001: {
                    if (nArray2[0] != 5) break;
                    n8 = calendar.get(5) - 1;
                    if (n8 >= 15) {
                        n8 -= 15;
                    }
                    bl3 = n8 > 7;
                    n9 = 1;
                    break;
                }
                case 9: {
                    if (nArray2[0] != 11) break;
                    n8 = calendar.get(11);
                    if (n8 >= 12) {
                        n8 -= 12;
                    }
                    bl3 = n8 >= 6;
                    n9 = 1;
                    break;
                }
            }
            if (n9 == 0) {
                int n7;
                int n10 = calendar.getActualMinimum(nArray2[0]);
                n7 = calendar.getActualMaximum(nArray2[0]);
                n8 = calendar.get(nArray2[0]) - n10;
                boolean bl4 = bl3 = n8 > (n7 - n10) / 2;
            }
            if (n8 == 0) continue;
            calendar.set(nArray2[0], calendar.get(nArray2[0]) - n8);
        }
        throw new IllegalArgumentException("The field " + n2 + " is not supported");
    }

    public static Date parseDate(String string, Locale locale, String ... stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, locale, stringArray, true);
    }

    public static Date parseDate(String string, String ... stringArray) throws ParseException {
        return DateUtils.parseDate(string, null, stringArray);
    }

    public static Date parseDateStrictly(String string, Locale locale, String ... stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, locale, stringArray, false);
    }

    public static Date parseDateStrictly(String string, String ... stringArray) throws ParseException {
        return DateUtils.parseDateStrictly(string, null, stringArray);
    }

    private static Date parseDateWithLeniency(String string, Locale locale, String[] stringArray, boolean bl2) throws ParseException {
        Objects.requireNonNull(string, "str");
        Objects.requireNonNull(stringArray, "parsePatterns");
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale2 = LocaleUtils.toLocale(locale);
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(timeZone, locale2);
        calendar.setLenient(bl2);
        for (String string2 : stringArray) {
            FastDateParser fastDateParser = new FastDateParser(string2, timeZone, locale2);
            calendar.clear();
            try {
                if (fastDateParser.parse(string, parsePosition, calendar) && parsePosition.getIndex() == string.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            parsePosition.setIndex(0);
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    public static Calendar round(Calendar calendar, int n2) {
        Objects.requireNonNull(calendar, "calendar");
        return DateUtils.modify((Calendar)calendar.clone(), n2, ModifyType.ROUND);
    }

    public static Date round(Date date, int n2) {
        return DateUtils.modify(DateUtils.toCalendar(date), n2, ModifyType.ROUND).getTime();
    }

    public static Date round(Object object, int n2) {
        Objects.requireNonNull(object, "date");
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    private static Date set(Date date, int n2, int n3) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n2, n3);
        return calendar.getTime();
    }

    public static Date setDays(Date date, int n2) {
        return DateUtils.set(date, 5, n2);
    }

    public static Date setHours(Date date, int n2) {
        return DateUtils.set(date, 11, n2);
    }

    public static Date setMilliseconds(Date date, int n2) {
        return DateUtils.set(date, 14, n2);
    }

    public static Date setMinutes(Date date, int n2) {
        return DateUtils.set(date, 12, n2);
    }

    public static Date setMonths(Date date, int n2) {
        return DateUtils.set(date, 2, n2);
    }

    public static Date setSeconds(Date date, int n2) {
        return DateUtils.set(date, 13, n2);
    }

    public static Date setYears(Date date, int n2) {
        return DateUtils.set(date, 1, n2);
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Objects.requireNonNull(date, "date"));
        return calendar;
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(Objects.requireNonNull(date, "date"));
        return calendar;
    }

    public static Calendar truncate(Calendar calendar, int n2) {
        Objects.requireNonNull(calendar, "date");
        return DateUtils.modify((Calendar)calendar.clone(), n2, ModifyType.TRUNCATE);
    }

    public static Date truncate(Date date, int n2) {
        return DateUtils.modify(DateUtils.toCalendar(date), n2, ModifyType.TRUNCATE).getTime();
    }

    public static Date truncate(Object object, int n2) {
        Objects.requireNonNull(object, "date");
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n2) {
        Calendar calendar3 = DateUtils.truncate(calendar, n2);
        Calendar calendar4 = DateUtils.truncate(calendar2, n2);
        return calendar3.compareTo(calendar4);
    }

    public static int truncatedCompareTo(Date date, Date date2, int n2) {
        Date date3 = DateUtils.truncate(date, n2);
        Date date4 = DateUtils.truncate(date2, n2);
        return date3.compareTo(date4);
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n2) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n2) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n2) {
        return DateUtils.truncatedCompareTo(date, date2, n2) == 0;
    }

    private static void validateDateNotNull(Date date) {
        Objects.requireNonNull(date, "date");
    }

    @Deprecated
    public DateUtils() {
    }

    private static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        @Override
        public Calendar next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return (Calendar)this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

