/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.Validate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Stream;

public class DurationFormatUtils {
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTES = 60;
    private static final int HOURS_PER_DAY = 24;
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final String y = "y";
    static final String M = "M";
    static final String d = "d";
    static final String H = "H";
    static final String m = "m";
    static final String s = "s";
    static final String S = "S";

    static String format(Token[] tokenArray, long l2, long l3, long l4, long l5, long l6, long l7, long l8, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = -1;
        boolean bl5 = false;
        int n3 = -1;
        boolean bl6 = false;
        for (Token token : tokenArray) {
            Object object = token.getValue();
            boolean bl7 = object instanceof StringBuilder;
            int n4 = token.getCount();
            if (n3 != token.optionalIndex) {
                n3 = token.optionalIndex;
                if (n3 > -1) {
                    n2 = stringBuilder.length();
                    bl4 = false;
                    bl6 = true;
                    bl5 = false;
                } else {
                    bl6 = false;
                }
            }
            if (bl7) {
                if (!bl6 || !bl4) {
                    stringBuilder.append(object.toString());
                }
            } else if (object.equals(y)) {
                bl3 = false;
                boolean bl8 = bl4 = l2 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l2, bl2, n4));
                }
            } else if (object.equals(M)) {
                bl3 = false;
                boolean bl9 = bl4 = l3 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l3, bl2, n4));
                }
            } else if (object.equals(d)) {
                bl3 = false;
                boolean bl10 = bl4 = l4 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l4, bl2, n4));
                }
            } else if (object.equals(H)) {
                bl3 = false;
                boolean bl11 = bl4 = l5 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l5, bl2, n4));
                }
            } else if (object.equals(m)) {
                bl3 = false;
                boolean bl12 = bl4 = l6 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l6, bl2, n4));
                }
            } else if (object.equals(s)) {
                bl3 = true;
                boolean bl13 = bl4 = l7 == 0L;
                if (!bl6 || !bl4) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l7, bl2, n4));
                }
            } else if (object.equals(S)) {
                boolean bl14 = bl4 = l8 == 0L;
                if (!bl6 || !bl4) {
                    if (bl3) {
                        int n5 = bl2 ? Math.max(3, n4) : 3;
                        stringBuilder.append(DurationFormatUtils.paddedValue(l8, true, n5));
                    } else {
                        stringBuilder.append(DurationFormatUtils.paddedValue(l8, bl2, n4));
                    }
                }
                bl3 = false;
            }
            if (!bl6 || bl7 || bl5) continue;
            bl5 = true;
            if (!bl4) continue;
            stringBuilder.delete(n2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String string, boolean bl2) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, l2, "durationMillis must not be negative");
        Token[] tokenArray = DurationFormatUtils.lexx(string);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        if (Token.containsTokenWithValue(tokenArray, d)) {
            l3 = l7 / 86400000L;
            l7 -= l3 * 86400000L;
        }
        if (Token.containsTokenWithValue(tokenArray, H)) {
            l4 = l7 / 3600000L;
            l7 -= l4 * 3600000L;
        }
        if (Token.containsTokenWithValue(tokenArray, m)) {
            l5 = l7 / 60000L;
            l7 -= l5 * 60000L;
        }
        if (Token.containsTokenWithValue(tokenArray, s)) {
            l6 = l7 / 1000L;
            l7 -= l6 * 1000L;
        }
        return DurationFormatUtils.format(tokenArray, 0L, 0L, l3, l4, l5, l6, l7, bl2);
    }

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDurationWords(long l2, boolean bl2, boolean bl3) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl2) {
            string2 = " " + string2;
            string = StringUtils.replaceOnce(string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
            }
            if (!string2.isEmpty()) {
                string2 = string2.substring(1);
            }
        }
        if (bl3 && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string, boolean bl2, TimeZone timeZone) {
        Validate.isTrue(l2 <= l3, "startMillis must not be greater than endMillis", new Object[0]);
        Token[] tokenArray = DurationFormatUtils.lexx(string);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        long l4 = calendar2.get(14) - calendar.get(14);
        int n2 = calendar2.get(13) - calendar.get(13);
        int n3 = calendar2.get(12) - calendar.get(12);
        int n4 = calendar2.get(11) - calendar.get(11);
        int n5 = calendar2.get(5) - calendar.get(5);
        int n6 = calendar2.get(2) - calendar.get(2);
        int n7 = calendar2.get(1) - calendar.get(1);
        while (l4 < 0L) {
            l4 += 1000L;
            --n2;
        }
        while (n2 < 0) {
            n2 += 60;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 24;
            --n5;
        }
        if (Token.containsTokenWithValue(tokenArray, M)) {
            while (n5 < 0) {
                n5 += calendar.getActualMaximum(5);
                --n6;
                calendar.add(2, 1);
            }
            while (n6 < 0) {
                n6 += 12;
                --n7;
            }
            if (!Token.containsTokenWithValue(tokenArray, y) && n7 != 0) {
                while (n7 != 0) {
                    n6 += 12 * n7;
                    n7 = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokenArray, y)) {
                int n8 = calendar2.get(1);
                if (n6 < 0) {
                    --n8;
                }
                while (calendar.get(1) != n8) {
                    n5 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n5;
                    }
                    calendar.add(1, 1);
                    n5 += calendar.get(6);
                }
                n7 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n5 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n6 = 0;
            while (n5 < 0) {
                n5 += calendar.getActualMaximum(5);
                --n6;
                calendar.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokenArray, d)) {
            n4 += 24 * n5;
            n5 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, H)) {
            n3 += 60 * n4;
            n4 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, m)) {
            n2 += 60 * n3;
            n3 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, s)) {
            l4 += 1000L * (long)n2;
            n2 = 0;
        }
        return DurationFormatUtils.format(tokenArray, n7, n6, n5, n4, n3, n2, l4, bl2);
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    static Token[] lexx(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>(string.length());
        boolean bl2 = false;
        StringBuilder stringBuilder = null;
        Token token = null;
        boolean bl3 = false;
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2 && c2 != '\'') {
                stringBuilder.append(c2);
                continue;
            }
            String string2 = null;
            switch (c2) {
                case '[': {
                    if (bl3) {
                        throw new IllegalArgumentException("Nested optional block at index: " + i2);
                    }
                    ++n2;
                    bl3 = true;
                    break;
                }
                case ']': {
                    if (!bl3) {
                        throw new IllegalArgumentException("Attempting to close unopened optional block at index: " + i2);
                    }
                    bl3 = false;
                    break;
                }
                case '\'': {
                    if (bl2) {
                        stringBuilder = null;
                        bl2 = false;
                        break;
                    }
                    stringBuilder = new StringBuilder();
                    arrayList.add(new Token(stringBuilder, bl3, n2));
                    bl2 = true;
                    break;
                }
                case 'y': {
                    string2 = y;
                    break;
                }
                case 'M': {
                    string2 = M;
                    break;
                }
                case 'd': {
                    string2 = d;
                    break;
                }
                case 'H': {
                    string2 = H;
                    break;
                }
                case 'm': {
                    string2 = m;
                    break;
                }
                case 's': {
                    string2 = s;
                    break;
                }
                case 'S': {
                    string2 = S;
                    break;
                }
                default: {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                        arrayList.add(new Token(stringBuilder, bl3, n2));
                    }
                    stringBuilder.append(c2);
                }
            }
            if (string2 == null) continue;
            if (token != null && token.getValue().equals(string2)) {
                token.increment();
            } else {
                Token token2 = new Token(string2, bl3, n2);
                arrayList.add(token2);
                token = token2;
            }
            stringBuilder = null;
        }
        if (bl2) {
            throw new IllegalArgumentException("Unmatched quote in format: " + string);
        }
        if (bl3) {
            throw new IllegalArgumentException("Unmatched optional in format: " + string);
        }
        return arrayList.toArray(Token.EMPTY_ARRAY);
    }

    private static String paddedValue(long l2, boolean bl2, int n2) {
        String string = Long.toString(l2);
        return bl2 ? StringUtils.leftPad(string, n2, '0') : string;
    }

    @Deprecated
    public DurationFormatUtils() {
    }

    static class Token {
        private static final Token[] EMPTY_ARRAY = new Token[0];
        private final CharSequence value;
        private int count;
        private int optionalIndex = -1;

        static boolean containsTokenWithValue(Token[] tokenArray, Object object) {
            return Stream.of(tokenArray).anyMatch(token -> token.getValue() == object);
        }

        Token(CharSequence charSequence, boolean bl2, int n2) {
            this.value = Objects.requireNonNull(charSequence, "value");
            this.count = 1;
            if (bl2) {
                this.optionalIndex = n2;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                Token token = (Token)object;
                if (this.value.getClass() != token.value.getClass()) {
                    return false;
                }
                if (this.count != token.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(token.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(token.value);
                }
                return this.value == token.value;
            }
            return false;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

