/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.config;

import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

public class MessageConstraints
implements Cloneable {
    public static final MessageConstraints DEFAULT = new Builder().build();
    private final int maxLineLength;
    private final int maxHeaderCount;

    MessageConstraints(int n2, int n3) {
        this.maxLineLength = n2;
        this.maxHeaderCount = n3;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    protected MessageConstraints clone() throws CloneNotSupportedException {
        return (MessageConstraints)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[maxLineLength=").append(this.maxLineLength).append(", maxHeaderCount=").append(this.maxHeaderCount).append("]");
        return stringBuilder.toString();
    }

    public static MessageConstraints lineLen(int n2) {
        return new MessageConstraints(Args.notNegative(n2, "Max line length"), -1);
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(MessageConstraints messageConstraints) {
        Args.notNull(messageConstraints, "Message constraints");
        return new Builder().setMaxHeaderCount(messageConstraints.getMaxHeaderCount()).setMaxLineLength(messageConstraints.getMaxLineLength());
    }

    public static class Builder {
        private int maxLineLength = -1;
        private int maxHeaderCount = -1;

        Builder() {
        }

        public Builder setMaxLineLength(int n2) {
            this.maxLineLength = n2;
            return this;
        }

        public Builder setMaxHeaderCount(int n2) {
            this.maxHeaderCount = n2;
            return this;
        }

        public MessageConstraints build() {
            return new MessageConstraints(this.maxLineLength, this.maxHeaderCount);
        }
    }
}

