/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.client;

import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthScheme;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthState;
import com.contrastsecurity.thirdparty.org.apache.http.auth.Credentials;
import com.contrastsecurity.thirdparty.org.apache.http.client.UserTokenHandler;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ManagedHttpClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext httpContext) {
        SSLSession sSLSession;
        Object object;
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Principal principal = null;
        AuthState authState = httpClientContext.getTargetAuthState();
        if (authState != null && (principal = DefaultUserTokenHandler.getAuthPrincipal(authState)) == null) {
            object = httpClientContext.getProxyAuthState();
            principal = DefaultUserTokenHandler.getAuthPrincipal((AuthState)object);
        }
        if (principal == null && (object = httpClientContext.getConnection()).isOpen() && object instanceof ManagedHttpClientConnection && (sSLSession = ((ManagedHttpClientConnection)object).getSSLSession()) != null) {
            principal = sSLSession.getLocalPrincipal();
        }
        return principal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials credentials;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isComplete() && authScheme.isConnectionBased() && (credentials = authState.getCredentials()) != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }
}

